/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttMessageReplyToAddressCalculator;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttMessagingStub
implements IMessaging {
    private static final String PRIORITY_LOW = "/low/";
    private static final String RAW = "/low/raw";
    private MqttAddress address;
    private JoynrMqttClient mqttClient;
    private JoynrMessageSerializer messageSerializer;
    private MqttMessageReplyToAddressCalculator mqttMessageReplyToAddressCalculator;

    public MqttMessagingStub(MqttAddress address, JoynrMqttClient mqttClient, JoynrMessageSerializer messageSerializer, MqttMessageReplyToAddressCalculator mqttMessageReplyToAddressCalculator) {
        this.address = address;
        this.mqttClient = mqttClient;
        this.messageSerializer = messageSerializer;
        this.mqttMessageReplyToAddressCalculator = mqttMessageReplyToAddressCalculator;
    }

    public void transmit(JoynrMessage message, FailureAction failureAction) {
        this.mqttMessageReplyToAddressCalculator.setReplyTo(message);
        String topic = this.address.getTopic() + PRIORITY_LOW + message.getTo();
        String serializedMessage = this.messageSerializer.serialize(message);
        try {
            this.mqttClient.publishMessage(topic, serializedMessage);
        }
        catch (Exception error) {
            failureAction.execute((Throwable)error);
        }
    }

    public void transmit(String serializedMessage, FailureAction failureAction) {
        String topic = this.address.getTopic() + RAW;
        try {
            this.mqttClient.publishMessage(topic, serializedMessage);
        }
        catch (Exception error) {
            failureAction.execute((Throwable)error);
        }
    }
}

