/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.joynr.accesscontrol.StaticDomainAccessControlProvisioningModule;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.jeeintegration.JeeJoynrIntegrationModule;
import io.joynr.jeeintegration.JoynrRuntimeFactory;
import io.joynr.jeeintegration.api.JoynrLocalDomain;
import io.joynr.jeeintegration.api.JoynrProperties;
import io.joynr.provider.JoynrProvider;
import io.joynr.runtime.CCInProcessRuntimeModule;
import io.joynr.runtime.JoynrInjectorFactory;
import io.joynr.runtime.JoynrRuntime;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJoynrRuntimeFactory
implements JoynrRuntimeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJoynrRuntimeFactory.class);
    private static final String MQTT = "mqtt";
    private static final String LOCALHOST_URL = "https://localhost:8443/";
    private Properties joynrProperties;
    private final String joynrLocalDomain;
    @Resource(name="concurrent/joynrMessagingScheduledExecutor")
    private ScheduledExecutorService scheduledExecutorService;
    private Injector fInjector = null;

    @Inject
    public DefaultJoynrRuntimeFactory(@JoynrProperties Instance<Properties> joynrProperties, @JoynrLocalDomain Instance<String> joynrLocalDomain) {
        Properties configuredProperties;
        if (joynrLocalDomain.isUnsatisfied() || joynrLocalDomain.isAmbiguous()) {
            String message = "No local domain name specified. Please provide a value for the local domain via @JoynrLocalDomain in your configuration EJB.";
            LOG.error(message);
            throw new JoynrIllegalStateException(message);
        }
        this.joynrLocalDomain = (String)joynrLocalDomain.get();
        if (!joynrProperties.isUnsatisfied() && !joynrProperties.isAmbiguous()) {
            configuredProperties = (Properties)joynrProperties.get();
        } else {
            LOG.info("No custom joynr properties provided. Will use default properties.");
            configuredProperties = new Properties();
        }
        this.joynrProperties = this.prepareJoynrProperties(configuredProperties);
    }

    @Override
    public JoynrRuntime create(Set<Class<? extends JoynrProvider>> providerInterfaceClasses) {
        LOG.info("Fetching consolidated joynr properties to use.");
        LOG.info("Provisioning access control for {}", providerInterfaceClasses);
        this.provisionAccessControl(this.joynrProperties, this.joynrLocalDomain, this.getProviderInterfaceNames(providerInterfaceClasses));
        LOG.info(String.format("Creating application with joynr properties:%n%s", this.joynrProperties));
        JoynrRuntime runtime = (JoynrRuntime)this.getInjector().getInstance(JoynrRuntime.class);
        LOG.info("Created runtime: {}", (Object)runtime);
        return runtime;
    }

    @Override
    public Injector getInjector() {
        if (this.fInjector == null) {
            this.fInjector = new JoynrInjectorFactory(this.joynrProperties, new Module[]{new StaticDomainAccessControlProvisioningModule(), Modules.override((Module[])new Module[]{new CCInProcessRuntimeModule()}).with(new Module[]{new JeeJoynrIntegrationModule(this.scheduledExecutorService)})}).getInjector();
        }
        return this.fInjector;
    }

    private Properties prepareJoynrProperties(Properties configuredProperties) {
        Properties defaultJoynrProperties = new Properties();
        defaultJoynrProperties.setProperty("joynr.domain.local", this.joynrLocalDomain);
        defaultJoynrProperties.setProperty("joynr.messaging.primaryglobaltransport", MQTT);
        String defaultDiscoveryDirectoryUrl = this.getEnvWithDefault("CAPABILITYDIRECTORYURL", "https://localhost:8443/discovery/channels/discoverydirectory_channelid/");
        defaultJoynrProperties.setProperty("joynr.messaging.discoverydirectoryurl", this.getEnvWithDefault("DISCOVERYDIRECTORYURL", defaultDiscoveryDirectoryUrl));
        defaultJoynrProperties.putAll((Map<?, ?>)configuredProperties);
        return defaultJoynrProperties;
    }

    private String[] getProviderInterfaceNames(Set<Class<? extends JoynrProvider>> providerInterfaceClasses) {
        HashSet<String> providerInterfaceNames = new HashSet<String>();
        for (Class<? extends JoynrProvider> providerInterfaceClass : providerInterfaceClasses) {
            providerInterfaceNames.add(this.getInterfaceName(providerInterfaceClass));
        }
        return providerInterfaceNames.toArray(new String[providerInterfaceNames.size()]);
    }

    private String getInterfaceName(Class<? extends JoynrProvider> providerInterfaceClass) {
        try {
            Field interfaceNameField = providerInterfaceClass.getField("INTERFACE_NAME");
            return (String)interfaceNameField.get(providerInterfaceClass);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.debug("error getting interface details", (Throwable)e);
            return providerInterfaceClass.getSimpleName();
        }
    }

    private String getEnvWithDefault(String variableName, String defaultValue) {
        String value = System.getenv(variableName);
        if (value == null || value.trim().isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    private void provisionAccessControl(Properties properties, String domain, String[] interfaceNames) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "_typeName");
        ArrayList<MasterAccessControlEntry> allEntries = new ArrayList<MasterAccessControlEntry>();
        for (String interfaceName : interfaceNames) {
            MasterAccessControlEntry newMasterAccessControlEntry = new MasterAccessControlEntry("*", domain, interfaceName, TrustLevel.LOW, new TrustLevel[]{TrustLevel.LOW}, TrustLevel.LOW, new TrustLevel[]{TrustLevel.LOW}, "*", Permission.YES, new Permission[]{Permission.YES});
            allEntries.add(newMasterAccessControlEntry);
        }
        MasterAccessControlEntry[] provisionedAccessControlEntries = allEntries.toArray(new MasterAccessControlEntry[allEntries.size()]);
        try {
            String provisionedAccessControlEntriesAsJson = objectMapper.writeValueAsString((Object)provisionedAccessControlEntries);
            properties.setProperty("joynr.accesscontrol.provisioned.masteraces", provisionedAccessControlEntriesAsJson);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error parsing JSON.", (Throwable)e);
        }
    }

    @Override
    public String getLocalDomain() {
        return this.joynrLocalDomain;
    }
}

