/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.google.inject.Injector;
import io.joynr.dispatcher.rpc.MultiReturnValuesContainer;
import io.joynr.jeeintegration.api.security.JoynrCallingPrincipal;
import io.joynr.jeeintegration.context.JoynrJeeMessageContext;
import io.joynr.messaging.JoynrMessageCreator;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Deferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.JoynrProvider;
import io.joynr.provider.MultiValueDeferred;
import io.joynr.provider.Promise;
import io.joynr.provider.SubscriptionPublisherInjection;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderWrapper
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderWrapper.class);
    private static final List<Method> OBJECT_METHODS = Arrays.asList(Object.class.getMethods());
    private Bean<?> bean;
    private BeanManager beanManager;
    private Injector injector;

    public ProviderWrapper(Bean<?> bean, BeanManager beanManager, Injector injector) {
        this.bean = bean;
        this.beanManager = beanManager;
        this.injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        boolean isProviderMethod = this.matchesJoynrProviderMethod(method);
        Method delegateToMethod = this.getMethodFromInterfaces(this.bean.getBeanClass(), method, isProviderMethod);
        Object delegate = this.createDelegateForMethod(method, isProviderMethod);
        try {
            if (this.isProviderMethod(method, delegateToMethod)) {
                JoynrJeeMessageContext.getInstance().activate();
                this.copyMessageCreatorInfo();
            }
            result = delegateToMethod.invoke(delegate, args);
            if (delegate != this) {
                Promise promiseResult;
                MultiValueDeferred deferred;
                if (result == null && method.getReturnType().equals(Void.class)) {
                    deferred = new DeferredVoid();
                    ((DeferredVoid)deferred).resolve();
                } else if (result instanceof MultiReturnValuesContainer) {
                    deferred = new MultiValueDeferred();
                    deferred.resolve(((MultiReturnValuesContainer)result).getValues());
                } else {
                    deferred = new Deferred();
                    ((Deferred)deferred).resolve(result);
                }
                Promise promise = promiseResult = new Promise((AbstractDeferred)deferred);
                return promise;
            }
        }
        finally {
            if (this.isProviderMethod(method, delegateToMethod)) {
                JoynrJeeMessageContext.getInstance().deactivate();
            }
        }
        return result;
    }

    private boolean isProviderMethod(Method method, Method delegateToMethod) {
        boolean result;
        boolean bl = result = delegateToMethod != method;
        if (method.getDeclaringClass().equals(SubscriptionPublisherInjection.class)) {
            result = false;
        }
        return result;
    }

    private void copyMessageCreatorInfo() {
        JoynrMessageCreator joynrMessageCreator = (JoynrMessageCreator)this.injector.getInstance(JoynrMessageCreator.class);
        Set beans = this.beanManager.getBeans(JoynrCallingPrincipal.class, new Annotation[0]);
        if (beans.size() != 1) {
            throw new IllegalStateException("There must be exactly one EJB of type " + JoynrCallingPrincipal.class.getName() + ". Found " + beans.size());
        }
        Bean bean = (Bean)beans.iterator().next();
        JoynrCallingPrincipal reference = (JoynrCallingPrincipal)this.beanManager.getReference(bean, JoynrCallingPrincipal.class, this.beanManager.createCreationalContext((Contextual)bean));
        String messageCreatorId = joynrMessageCreator.getMessageCreatorId();
        LOG.trace("Setting user '{}' for message processing context.", (Object)messageCreatorId);
        reference.setUsername(messageCreatorId);
    }

    private Object createDelegateForMethod(Method method, boolean isProviderMethod) {
        if (OBJECT_METHODS.contains(method) || isProviderMethod) {
            return this;
        }
        return this.bean.create(this.beanManager.createCreationalContext(this.bean));
    }

    private Method getMethodFromInterfaces(Class<?> beanClass, Method method, boolean isProviderMethod) throws NoSuchMethodException {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Method result = method;
        if (!isProviderMethod) {
            result = null;
            for (Class<?> interfaceClass : beanClass.getInterfaces()) {
                try {
                    result = interfaceClass.getMethod(name, parameterTypes);
                    if (result == null) continue;
                    break;
                }
                catch (NoSuchMethodException | SecurityException e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(String.format("Method %s not found on interface %s", name, interfaceClass));
                }
            }
        }
        return result == null ? method : result;
    }

    private boolean matchesJoynrProviderMethod(Method method) {
        boolean result = false;
        for (Method joynrProviderMethod : JoynrProvider.class.getMethods()) {
            if (!joynrProviderMethod.getName().equals(method.getName()) || !Arrays.equals(joynrProviderMethod.getParameterTypes(), method.getParameterTypes())) continue;
            result = true;
            break;
        }
        return result;
    }
}

