/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.joynr.messaging.routing.MessageRouterImpl;
import io.joynr.messaging.routing.MessagingStubFactory;
import io.joynr.messaging.routing.RoutingTable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="ensure that no new messages are scheduled when scheduler is shuting down")
public class JeeMessageRouter
extends MessageRouterImpl {
    private static final Logger LOG = LoggerFactory.getLogger(JeeMessageRouter.class);
    private ScheduledExecutorService scheduler;

    @Inject
    public JeeMessageRouter(RoutingTable routingTable, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduler, @Named(value="joynr.messaging.sendmsgretryintervalms") long sendMsgRetryIntervalMs, MessagingStubFactory messagingStubFactory) {
        super(routingTable, scheduler, sendMsgRetryIntervalMs, messagingStubFactory);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Initialising with:%n\troutingTable: %s%n\tscheduler: %s%n\tsendMsgRetryIntervalMs: %d%n\tmessageStubFactory: %s", routingTable, scheduler, sendMsgRetryIntervalMs, messagingStubFactory));
        }
        this.scheduler = scheduler;
    }

    protected void schedule(Runnable runnable, String messageId, long delay, TimeUnit timeUnit) {
        LOG.trace("Scheduling {} on {} with delay {} {}", new Object[]{runnable, this.scheduler, delay, timeUnit});
        this.scheduler.schedule(runnable, delay, timeUnit);
    }
}

