/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.google.inject.Injector;
import io.joynr.jeeintegration.JoynrRuntimeFactory;
import io.joynr.jeeintegration.ProviderWrapper;
import io.joynr.jeeintegration.ServiceProviderDiscovery;
import io.joynr.jeeintegration.api.ProviderDomain;
import io.joynr.jeeintegration.api.ProviderQosFactory;
import io.joynr.jeeintegration.api.ServiceProvider;
import io.joynr.runtime.JoynrRuntime;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import joynr.types.ProviderQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class JoynrIntegrationBean {
    private static final Logger LOG = LoggerFactory.getLogger(JoynrIntegrationBean.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private JoynrRuntimeFactory joynrRuntimeFactory;
    @Inject
    private ServiceProviderDiscovery serviceProviderDiscovery;
    private Set<Object> registeredProviders = new HashSet<Object>();
    private JoynrRuntime joynrRuntime;

    public JoynrIntegrationBean() {
    }

    public JoynrIntegrationBean(BeanManager beanManager, JoynrRuntimeFactory joynrRuntimeFactory, ServiceProviderDiscovery serviceProviderDiscovery) {
        this.beanManager = beanManager;
        this.joynrRuntimeFactory = joynrRuntimeFactory;
        this.serviceProviderDiscovery = serviceProviderDiscovery;
    }

    @PostConstruct
    public void initialise() {
        Set<Bean<?>> serviceProviderBeans = this.serviceProviderDiscovery.findServiceProviderBeans();
        this.joynrRuntime = this.joynrRuntimeFactory.create(this.getServiceProviderInterfaceClasses(serviceProviderBeans));
        this.registerProviders(serviceProviderBeans, this.joynrRuntime);
    }

    private void registerProviders(Set<Bean<?>> serviceProviderBeans, JoynrRuntime runtime) {
        Set<ProviderQosFactory> providerQosFactories = this.getProviderQosFactories();
        for (Bean<?> bean : serviceProviderBeans) {
            Class beanClass = bean.getBeanClass();
            ServiceProvider providerService = beanClass.getAnnotation(ServiceProvider.class);
            Class<?> serviceInterface = this.serviceProviderDiscovery.getProviderInterfaceFor(providerService.serviceInterface());
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Registering %s as provider with joynr runtime for service interface %s.", bean, serviceInterface));
            }
            Object provider = Proxy.newProxyInstance(beanClass.getClassLoader(), new Class[]{serviceInterface}, (InvocationHandler)new ProviderWrapper(bean, this.beanManager, this.joynrRuntimeFactory.getInjector()));
            ProviderQos providerQos = null;
            for (ProviderQosFactory factory : providerQosFactories) {
                if (!factory.providesFor(serviceInterface)) continue;
                providerQos = factory.create();
                break;
            }
            runtime.registerProvider(this.getDomainForProvider(beanClass), provider, providerQos);
            this.registeredProviders.add(provider);
        }
    }

    private String getDomainForProvider(Class<?> beanClass) {
        ProviderDomain providerDomain = beanClass.getAnnotation(ProviderDomain.class);
        String domain = providerDomain != null ? providerDomain.value() : this.joynrRuntimeFactory.getLocalDomain();
        return domain;
    }

    private Set<ProviderQosFactory> getProviderQosFactories() {
        Set providerQosFactoryBeans = this.beanManager.getBeans(ProviderQosFactory.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        HashSet<ProviderQosFactory> providerQosFactories = new HashSet<ProviderQosFactory>();
        for (Bean providerQosFactoryBean : providerQosFactoryBeans) {
            ProviderQosFactory factory = (ProviderQosFactory)providerQosFactoryBean.create(this.beanManager.createCreationalContext((Contextual)providerQosFactoryBean));
            providerQosFactories.add(factory);
        }
        return providerQosFactories;
    }

    @PreDestroy
    public void destroy() {
        for (Object provider : this.registeredProviders) {
            try {
                this.joynrRuntime.unregisterProvider(this.joynrRuntimeFactory.getLocalDomain(), provider);
            }
            catch (Exception e) {
                LOG.error("Error unregistering provider", (Throwable)e);
            }
        }
    }

    public Injector getJoynrInjector() {
        return this.joynrRuntimeFactory.getInjector();
    }

    private Set<Class<?>> getServiceProviderInterfaceClasses(Set<Bean<?>> serviceProviderBeans) {
        HashSet result = new HashSet();
        for (Bean<?> bean : serviceProviderBeans) {
            result.add(bean.getBeanClass().getAnnotation(ServiceProvider.class).serviceInterface());
        }
        return result;
    }

    public JoynrRuntime getRuntime() {
        return this.joynrRuntime;
    }
}

