/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import io.joynr.communications.exceptions.JoynrHttpException;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.jeeintegration.JoynrIntegrationBean;
import io.joynr.messaging.datatypes.JoynrErrorCode;
import io.joynr.messaging.datatypes.JoynrMessagingErrorCode;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import joynr.JoynrMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/channels")
public class JeeMessagingEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JeeMessagingEndpoint.class);
    private Injector injector;
    private ObjectMapper objectMapper;
    private ServletMessageReceiver messageReceiver;

    @Inject
    public JeeMessagingEndpoint(JoynrIntegrationBean jeeIntegrationBean) {
        this.injector = jeeIntegrationBean.getJoynrInjector();
        this.objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        this.messageReceiver = (ServletMessageReceiver)this.injector.getInstance(ServletMessageReceiver.class);
    }

    @GET
    public Response status() {
        LOG.info("Status called.");
        return Response.status((int)200).build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @Path(value="/{ccid: [A-Z,a-z,0-9,_,\\-,\\.]+}/messageWithoutContentType")
    public Response postMessageWithoutContentType(@PathParam(value="ccid") String ccid, String messageString, @Context UriInfo uriInfo) throws IOException, JsonParseException, JsonMappingException {
        return this.postMessage(ccid, messageString, uriInfo);
    }

    @POST
    @Path(value="/{channelId: [A-Z,a-z,0-9,_,\\-,\\.]+}/message")
    @Produces(value={"application/json"})
    public Response postMessage(@PathParam(value="channelId") String channelId, String messageString, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Incoming message:\n" + messageString);
        }
        try {
            JoynrMessage message = (JoynrMessage)this.objectMapper.readValue(messageString, JoynrMessage.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("POST to channel: {} message: {}", (Object)channelId, (Object)message);
            }
            if (channelId == null) {
                LOG.error("POST message to channel: NULL. message: {} dropped because: channel Id was not set", (Object)message);
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_CHANNELNOTSET);
            }
            if (message.getExpiryDate() == 0L) {
                LOG.error("POST message to channel: {} message: {} dropped because: TTL not set", (Object)channelId, (Object)message);
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_EXPIRYDATENOTSET);
            }
            if (this.messageReceiver == null) {
                LOG.error("POST message to channel: {} message: {} no receiver for the given channel", (Object)channelId, (Object)message);
                return Response.noContent().build();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("passing off message to messageReceiver: {}", (Object)channelId);
            }
            this.messageReceiver.receive(message);
            URI location = uriInfo.getBaseUriBuilder().path("messages/" + message.getId()).build(new Object[0]);
            return Response.created((URI)location).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(String.format("POST message to channel: %s error: %s", channelId, e.getMessage()), (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

