/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.jeeintegration.httpbridge.HttpBridgeRegistryClient;
import io.joynr.messaging.MessageArrivedListener;
import io.joynr.messaging.ReceiverStatusListener;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import joynr.JoynrMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JeeServletMessageReceiver
implements ServletMessageReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(JeeServletMessageReceiver.class);
    private final String channelId;
    private final String hostPath;
    private final String contextRoot;
    private boolean registered = false;
    private MessageArrivedListener messageListener;
    private final HttpBridgeRegistryClient httpBridgeRegistryClient;
    private boolean httpBridgeEnabled;

    @Inject
    public JeeServletMessageReceiver(@Named(value="joynr.messaging.channelid") String channelId, @Named(value="joynr.servlet.context.root") String contextRoot, @Named(value="joynr.servlet.hostpath") String hostPath, HttpBridgeRegistryClient httpBridgeRegistryClient, @Named(value="joynr.jeeintegration.enable.httpbridge") String httpBridgeEnabled) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Initialising with:%n\tchannelId: %s%n\tcontextRoot: %s%n\thostPath: %s%n\thttpBridgeRegistryClient: %s", channelId, contextRoot, hostPath, httpBridgeRegistryClient));
        }
        this.channelId = channelId;
        this.hostPath = hostPath;
        this.contextRoot = contextRoot;
        this.httpBridgeRegistryClient = httpBridgeRegistryClient;
        this.httpBridgeEnabled = Boolean.valueOf(httpBridgeEnabled);
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void shutdown(boolean clear) {
        if (this.registered) {
            LOG.info("Shutting down servlet message receiver.");
            this.registered = false;
        }
    }

    public boolean isReady() {
        return this.messageListener != null;
    }

    public boolean deleteChannel() {
        LOG.info(String.format("Deleting channel %s", this.channelId));
        return false;
    }

    public boolean isStarted() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("isStarted called - returning %s", this.registered));
        }
        return this.registered;
    }

    public void suspend() {
        LOG.info(String.format("Suspend called on channel %s, but functionality not supported. Ignoring.", this.channelId));
    }

    public void resume() {
        LOG.info(String.format("Resume called on channel %s, but functionality not supported. Ignoring.", this.channelId));
    }

    public Future<Void> start(MessageArrivedListener messageArrivedListener, ReceiverStatusListener ... receiverStatusListeners) {
        if (messageArrivedListener == null) {
            throw new IllegalStateException();
        }
        LOG.info("Starting JeeServletMessageReceiver with listener {}", (Object)messageArrivedListener);
        this.messageListener = messageArrivedListener;
        if (!this.registered) {
            this.registerChannelUrl();
        }
        return Futures.immediateFuture(null);
    }

    public boolean switchToLongPolling() {
        LOG.info(String.format("JEE servlet message receiver does not support long polling. Ignoring.", new Object[0]));
        return false;
    }

    public void receive(JoynrMessage message) {
        if (message != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format(">>>>>> Message arrived on channel %s:%n\t%s%n", this.channelId, message));
            }
            this.messageListener.messageArrived(message);
        } else {
            LOG.warn(String.format("Received null message on channel %s", this.channelId));
        }
    }

    public void onError(JoynrMessage message, Throwable error) {
        if (this.messageListener != null) {
            this.messageListener.error(message, error);
        } else {
            LOG.warn(String.format("Channel %s dropped message %s because no message listener available.%nError received: %s", this.channelId, message, error));
        }
    }

    private synchronized void registerChannelUrl() {
        if (!this.registered) {
            if (this.hostPath == null) {
                String message = "The system property hostPath must be set with name:port eg. http://localhost:8080";
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message);
                LOG.error(message, (Throwable)illegalArgumentException);
                throw illegalArgumentException;
            }
            if (this.httpBridgeEnabled) {
                LOG.debug("HTTP Bridge enabled - registering channel with endpoint registry.");
                String endpointUrl = this.hostPath + this.contextRoot + "/channels/" + this.channelId + "/";
                CompletionStage<Void> registrationResult = this.httpBridgeRegistryClient.register(endpointUrl, this.channelId);
                registrationResult.thenAccept(v -> {
                    this.registered = true;
                }).exceptionally(t -> {
                    LOG.error("Unable to register channel URL.", t);
                    return null;
                });
            } else {
                LOG.debug("HTTP Bridge disabled.");
                this.registered = true;
            }
        }
    }
}

