/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.jeeintegration.messaging.NoOpMessagingSkeleton;
import io.joynr.jeeintegration.messaging.SharedSubscriptionsMqttMessagingSkeleton;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageSerializerFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeleton;
import io.joynr.messaging.routing.MessageRouter;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingSkeletonProvider
implements Provider<IMessagingSkeleton> {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingSkeletonProvider.class);
    private boolean httpBridgeEnabled;
    private boolean sharedSubscriptionsEnabled;
    private MqttAddress ownAddress;
    private MessageRouter messageRouter;
    private MqttClientFactory mqttClientFactory;
    private MqttMessageSerializerFactory messageSerializerFactory;
    private String channelId;
    private String receiverId;

    @Inject
    public MqttMessagingSkeletonProvider(@Named(value="joynr.jeeintegration.enable.httpbridge") String enableHttpBridge, @Named(value="joynr.jeeintegration.enable.sharedsubscriptions") String enableSharedSubscriptions, @Named(value="property_mqtt_address") MqttAddress ownAddress, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, MqttMessageSerializerFactory messageSerializerFactory, @Named(value="joynr.messaging.channelid") String channelId, @Named(value="joynr.messaging.receiverid") String receiverId) {
        this.httpBridgeEnabled = Boolean.valueOf(enableHttpBridge);
        this.sharedSubscriptionsEnabled = Boolean.valueOf(enableSharedSubscriptions);
        this.ownAddress = ownAddress;
        this.messageRouter = messageRouter;
        this.mqttClientFactory = mqttClientFactory;
        this.messageSerializerFactory = messageSerializerFactory;
        this.channelId = channelId;
        this.receiverId = receiverId;
        logger.debug("Created with httpBridgeEnabled: {}\n\tsharedSubscriptionsEnabled: {}\n\townAddress: {}\n\tmessageRouter: {}\n\tmqttClientFactory: {}\n\tmessageSerializer: {}\n\tchannelId: {}", new Object[]{this.httpBridgeEnabled, this.sharedSubscriptionsEnabled, this.ownAddress, this.messageRouter, this.mqttClientFactory, this.messageSerializerFactory, this.channelId});
    }

    public IMessagingSkeleton get() {
        if (this.httpBridgeEnabled) {
            return new NoOpMessagingSkeleton(this.mqttClientFactory);
        }
        if (this.sharedSubscriptionsEnabled) {
            return new SharedSubscriptionsMqttMessagingSkeleton(this.ownAddress, this.messageRouter, this.mqttClientFactory, this.messageSerializerFactory, this.channelId, this.receiverId);
        }
        return new MqttMessagingSkeleton(this.ownAddress, this.messageRouter, this.mqttClientFactory, this.messageSerializerFactory);
    }
}

