/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.Pair;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.util.WebSocketStreamHandler;
import io.kubernetes.client.util.WebSockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PortForward {
    private ApiClient apiClient;

    public PortForward() {
        this(Configuration.getDefaultApiClient());
    }

    public PortForward(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private String makePath(String namespace, String name) {
        return "/api/v1/namespaces/" + namespace + "/pods/" + name + "/portforward";
    }

    public PortForwardResult forward(V1Pod pod, List<Integer> ports) throws ApiException, IOException {
        return this.forward(pod.getMetadata().getNamespace(), pod.getMetadata().getNamespace(), ports);
    }

    public PortForwardResult forward(String namespace, String name, List<Integer> ports) throws ApiException, IOException {
        String path = this.makePath(namespace, name);
        WebSocketStreamHandler handler = new WebSocketStreamHandler();
        PortForwardResult result = new PortForwardResult(handler, ports);
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        for (Integer port : ports) {
            queryParams.add(new Pair("ports", port.toString()));
        }
        WebSockets.stream(path, "GET", queryParams, this.apiClient, handler);
        result.init();
        return result;
    }

    public static class PortForwardResult {
        private WebSocketStreamHandler handler;
        private HashMap<Integer, Integer> streams;
        private List<Integer> ports;

        public PortForwardResult(WebSocketStreamHandler handler, List<Integer> ports) throws IOException {
            this.handler = handler;
            this.streams = new HashMap();
            this.ports = ports;
        }

        public void init() throws IOException {
            for (int i = 0; i < this.ports.size(); ++i) {
                InputStream is = this.handler.getInputStream(i * 2);
                byte[] data = new byte[2];
                is.read(data);
                int port = (data[0] & 0xFF) + (data[1] & 0xFF) * 256;
                this.streams.put(port, i);
            }
        }

        private int findPortIndex(int portNumber) {
            Integer ix = this.streams.get(portNumber);
            if (ix == null) {
                return -1;
            }
            return ix;
        }

        public OutputStream getOutboundStream(int port) {
            int portIndex = this.findPortIndex(port);
            if (portIndex == -1) {
                return null;
            }
            return this.handler.getOutputStream(portIndex * 2);
        }

        public OutputStream getErrorStream(int port) {
            int portIndex = this.findPortIndex(port);
            if (portIndex == -1) {
                return null;
            }
            return this.handler.getOutputStream(portIndex * 2 + 1);
        }

        public InputStream getInputStream(int port) throws IOException {
            int portIndex = this.findPortIndex(port);
            if (portIndex == -1) {
                return null;
            }
            return this.handler.getInputStream(portIndex * 2);
        }
    }
}

