/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Yaml {
    private static org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml();
    private static Map<String, Class<?>> classes = new HashMap();
    static final Logger logger = LoggerFactory.getLogger(Yaml.class);

    public static String getApiGroupVersion(String name) {
        if (name.startsWith("AppsV1")) {
            return "apps/v1";
        }
        if (name.startsWith("AppsV1beta1")) {
            return "apps/v1beta1";
        }
        if (name.startsWith("ExtensionsV1beta1")) {
            return "extensions/v1beta1";
        }
        if (name.startsWith("ExtensionsV1")) {
            return "extensions/v1";
        }
        if (name.startsWith("V1beta1")) {
            return "v1beta1";
        }
        if (name.startsWith("V1beta2")) {
            return "v1beta2";
        }
        if (name.startsWith("V1alpha1")) {
            return "v1alpha1";
        }
        if (name.startsWith("V2beta1")) {
            return "v2beta1";
        }
        if (name.startsWith("V2alpha1")) {
            return "v2alpha1";
        }
        if (name.startsWith("V1")) {
            return "v1";
        }
        return name;
    }

    private static void initModelMap() throws IOException {
        ClassPath cp = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader());
        ImmutableSet allClasses = cp.getTopLevelClasses("io.kubernetes.client.models");
        for (ClassPath.ClassInfo clazz : allClasses) {
            String groupVersion = Yaml.getApiGroupVersion(clazz.getSimpleName());
            int len = groupVersion.replace("/", "").length();
            String name = clazz.getSimpleName().substring(len);
            classes.put(groupVersion + "/" + name, clazz.load());
        }
    }

    public static void addModelMap(String apiGroupVersion, String kind, Class<?> clazz) {
        classes.put(apiGroupVersion + "/" + kind, clazz);
    }

    public static Object load(String content) throws IOException {
        return Yaml.load(new StringReader(content));
    }

    public static Object load(File f) throws IOException {
        return Yaml.load(new FileReader(f));
    }

    public static Object load(Reader reader) throws IOException {
        Map data = (Map)yaml.load(reader);
        String kind = (String)data.get("kind");
        if (kind == null) {
            throw new IOException("Missing kind in YAML file!");
        }
        String apiVersion = (String)data.get("apiVersion");
        if (apiVersion == null) {
            throw new IOException("Missing apiVersion in YAML file!");
        }
        Class<?> clazz = classes.get(apiVersion + "/" + kind);
        if (clazz == null) {
            throw new IOException("Unknown apiVersionKind: " + apiVersion + "/" + kind + " known kinds are: " + classes.toString());
        }
        return Yaml.loadAs(new StringReader(yaml.dump((Object)data)), clazz);
    }

    public static <T> T loadAs(String content, Class<T> clazz) {
        return (T)yaml.loadAs((Reader)new StringReader(content), clazz);
    }

    public static <T> T loadAs(File f, Class<T> clazz) throws IOException {
        return (T)yaml.loadAs((Reader)new FileReader(f), clazz);
    }

    public static <T> T loadAs(Reader reader, Class<T> clazz) {
        return (T)yaml.loadAs(reader, clazz);
    }

    static {
        try {
            Yaml.initModelMap();
        }
        catch (Exception ex) {
            logger.error("Unexpected exception while loading classes: " + ex);
        }
    }
}

