/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ClusterCIDRSpec defines the desired state of ClusterCIDR.")
public class V1alpha1ClusterCIDRSpec {
    public static final String SERIALIZED_NAME_IPV4 = "ipv4";
    @SerializedName(value="ipv4")
    private String ipv4;
    public static final String SERIALIZED_NAME_IPV6 = "ipv6";
    @SerializedName(value="ipv6")
    private String ipv6;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_PER_NODE_HOST_BITS = "perNodeHostBits";
    @SerializedName(value="perNodeHostBits")
    private Integer perNodeHostBits;

    public V1alpha1ClusterCIDRSpec ipv4(String ipv4) {
        this.ipv4 = ipv4;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPv4 defines an IPv4 IP block in CIDR notation(e.g. \"10.0.0.0/8\"). At least one of IPv4 and IPv6 must be specified. This field is immutable.")
    public String getIpv4() {
        return this.ipv4;
    }

    public void setIpv4(String ipv4) {
        this.ipv4 = ipv4;
    }

    public V1alpha1ClusterCIDRSpec ipv6(String ipv6) {
        this.ipv6 = ipv6;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPv6 defines an IPv6 IP block in CIDR notation(e.g. \"fd12:3456:789a:1::/64\"). At least one of IPv4 and IPv6 must be specified. This field is immutable.")
    public String getIpv6() {
        return this.ipv6;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public V1alpha1ClusterCIDRSpec nodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1alpha1ClusterCIDRSpec perNodeHostBits(Integer perNodeHostBits) {
        this.perNodeHostBits = perNodeHostBits;
        return this;
    }

    @ApiModelProperty(required=true, value="PerNodeHostBits defines the number of host bits to be configured per node. A subnet mask determines how much of the address is used for network bits and host bits. For example an IPv4 address of 192.168.0.0/24, splits the address into 24 bits for the network portion and 8 bits for the host portion. To allocate 256 IPs, set this field to 8 (a /24 mask for IPv4 or a /120 for IPv6). Minimum value is 4 (16 IPs). This field is immutable.")
    public Integer getPerNodeHostBits() {
        return this.perNodeHostBits;
    }

    public void setPerNodeHostBits(Integer perNodeHostBits) {
        this.perNodeHostBits = perNodeHostBits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ClusterCIDRSpec v1alpha1ClusterCIDRSpec = (V1alpha1ClusterCIDRSpec)o;
        return Objects.equals(this.ipv4, v1alpha1ClusterCIDRSpec.ipv4) && Objects.equals(this.ipv6, v1alpha1ClusterCIDRSpec.ipv6) && Objects.equals(this.nodeSelector, v1alpha1ClusterCIDRSpec.nodeSelector) && Objects.equals(this.perNodeHostBits, v1alpha1ClusterCIDRSpec.perNodeHostBits);
    }

    public int hashCode() {
        return Objects.hash(this.ipv4, this.ipv6, this.nodeSelector, this.perNodeHostBits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ClusterCIDRSpec {\n");
        sb.append("    ipv4: ").append(this.toIndentedString(this.ipv4)).append("\n");
        sb.append("    ipv6: ").append(this.toIndentedString(this.ipv6)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    perNodeHostBits: ").append(this.toIndentedString(this.perNodeHostBits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

