/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1AttachedVolume;
import io.kubernetes.client.openapi.models.V1ContainerImage;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeCondition;
import io.kubernetes.client.openapi.models.V1NodeConfigStatus;
import io.kubernetes.client.openapi.models.V1NodeDaemonEndpoints;
import io.kubernetes.client.openapi.models.V1NodeSystemInfo;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1NodeStatus {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<V1NodeAddress> addresses;
    public static final String SERIALIZED_NAME_ALLOCATABLE = "allocatable";
    @SerializedName(value="allocatable")
    private Map<String, Quantity> allocatable = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1NodeCondition> conditions;
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private V1NodeConfigStatus config;
    public static final String SERIALIZED_NAME_DAEMON_ENDPOINTS = "daemonEndpoints";
    @SerializedName(value="daemonEndpoints")
    private V1NodeDaemonEndpoints daemonEndpoints;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private List<V1ContainerImage> images;
    public static final String SERIALIZED_NAME_NODE_INFO = "nodeInfo";
    @SerializedName(value="nodeInfo")
    private V1NodeSystemInfo nodeInfo;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private String phase;
    public static final String SERIALIZED_NAME_VOLUMES_ATTACHED = "volumesAttached";
    @SerializedName(value="volumesAttached")
    private List<V1AttachedVolume> volumesAttached;
    public static final String SERIALIZED_NAME_VOLUMES_IN_USE = "volumesInUse";
    @SerializedName(value="volumesInUse")
    private List<String> volumesInUse;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NodeStatus addresses(List<V1NodeAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1NodeStatus addAddressesItem(V1NodeAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    public List<V1NodeAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<V1NodeAddress> addresses) {
        this.addresses = addresses;
    }

    public V1NodeStatus allocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable;
        return this;
    }

    public V1NodeStatus putAllocatableItem(String key, Quantity allocatableItem) {
        if (this.allocatable == null) {
            this.allocatable = new HashMap<String, Quantity>();
        }
        this.allocatable.put(key, allocatableItem);
        return this;
    }

    @Nullable
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    public void setAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable;
    }

    public V1NodeStatus capacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1NodeStatus putCapacityItem(String key, Quantity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, Quantity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    public V1NodeStatus conditions(List<V1NodeCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1NodeStatus addConditionsItem(V1NodeCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    public List<V1NodeCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1NodeCondition> conditions) {
        this.conditions = conditions;
    }

    public V1NodeStatus config(V1NodeConfigStatus config) {
        this.config = config;
        return this;
    }

    @Nullable
    public V1NodeConfigStatus getConfig() {
        return this.config;
    }

    public void setConfig(V1NodeConfigStatus config) {
        this.config = config;
    }

    public V1NodeStatus daemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
        return this;
    }

    @Nullable
    public V1NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints;
    }

    public void setDaemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
    }

    public V1NodeStatus images(List<V1ContainerImage> images) {
        this.images = images;
        return this;
    }

    public V1NodeStatus addImagesItem(V1ContainerImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    public List<V1ContainerImage> getImages() {
        return this.images;
    }

    public void setImages(List<V1ContainerImage> images) {
        this.images = images;
    }

    public V1NodeStatus nodeInfo(V1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
        return this;
    }

    @Nullable
    public V1NodeSystemInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(V1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public V1NodeStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1NodeStatus volumesAttached(List<V1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
        return this;
    }

    public V1NodeStatus addVolumesAttachedItem(V1AttachedVolume volumesAttachedItem) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolume>();
        }
        this.volumesAttached.add(volumesAttachedItem);
        return this;
    }

    @Nullable
    public List<V1AttachedVolume> getVolumesAttached() {
        return this.volumesAttached;
    }

    public void setVolumesAttached(List<V1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
    }

    public V1NodeStatus volumesInUse(List<String> volumesInUse) {
        this.volumesInUse = volumesInUse;
        return this;
    }

    public V1NodeStatus addVolumesInUseItem(String volumesInUseItem) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(volumesInUseItem);
        return this;
    }

    @Nullable
    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    public void setVolumesInUse(List<String> volumesInUse) {
        this.volumesInUse = volumesInUse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeStatus v1NodeStatus = (V1NodeStatus)o;
        return Objects.equals(this.addresses, v1NodeStatus.addresses) && Objects.equals(this.allocatable, v1NodeStatus.allocatable) && Objects.equals(this.capacity, v1NodeStatus.capacity) && Objects.equals(this.conditions, v1NodeStatus.conditions) && Objects.equals(this.config, v1NodeStatus.config) && Objects.equals(this.daemonEndpoints, v1NodeStatus.daemonEndpoints) && Objects.equals(this.images, v1NodeStatus.images) && Objects.equals(this.nodeInfo, v1NodeStatus.nodeInfo) && Objects.equals(this.phase, v1NodeStatus.phase) && Objects.equals(this.volumesAttached, v1NodeStatus.volumesAttached) && Objects.equals(this.volumesInUse, v1NodeStatus.volumesInUse);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.allocatable, this.capacity, this.conditions, this.config, this.daemonEndpoints, this.images, this.nodeInfo, this.phase, this.volumesAttached, this.volumesInUse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeStatus {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    allocatable: ").append(this.toIndentedString(this.allocatable)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    daemonEndpoints: ").append(this.toIndentedString(this.daemonEndpoints)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    nodeInfo: ").append(this.toIndentedString(this.nodeInfo)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    volumesAttached: ").append(this.toIndentedString(this.volumesAttached)).append("\n");
        sb.append("    volumesInUse: ").append(this.toIndentedString(this.volumesInUse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvolumesAttached;
        JsonArray jsonArrayimages;
        JsonArray jsonArrayconditions;
        JsonArray jsonArrayaddresses;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NodeStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NodeStatus` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonNull() && (jsonArrayaddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESSES).toString()));
            }
            for (int i = 0; i < jsonArrayaddresses.size(); ++i) {
                V1NodeAddress.validateJsonObject(jsonArrayaddresses.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1NodeCondition.validateJsonObject(jsonArrayconditions.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            V1NodeConfigStatus.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_DAEMON_ENDPOINTS) != null && !jsonObj.get(SERIALIZED_NAME_DAEMON_ENDPOINTS).isJsonNull()) {
            V1NodeDaemonEndpoints.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DAEMON_ENDPOINTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonNull() && (jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `images` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGES).toString()));
            }
            for (int i = 0; i < jsonArrayimages.size(); ++i) {
                V1ContainerImage.validateJsonObject(jsonArrayimages.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_INFO) != null && !jsonObj.get(SERIALIZED_NAME_NODE_INFO).isJsonNull()) {
            V1NodeSystemInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NODE_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED).isJsonNull() && (jsonArrayvolumesAttached = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES_ATTACHED)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumesAttached` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED).toString()));
            }
            for (int i = 0; i < jsonArrayvolumesAttached.size(); ++i) {
                V1AttachedVolume.validateJsonObject(jsonArrayvolumesAttached.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumesInUse` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE).toString()));
        }
    }

    public static V1NodeStatus fromJson(String jsonString) throws IOException {
        return (V1NodeStatus)JSON.getGson().fromJson(jsonString, V1NodeStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_ALLOCATABLE);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_DAEMON_ENDPOINTS);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_NODE_INFO);
        openapiFields.add(SERIALIZED_NAME_PHASE);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_ATTACHED);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_IN_USE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NodeStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NodeStatus.class));
            return new TypeAdapter<V1NodeStatus>(){

                public void write(JsonWriter out, V1NodeStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NodeStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1NodeStatus.validateJsonObject(jsonObj);
                    return (V1NodeStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

