/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1Sysctl;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1PodSecurityContext {
    public static final String SERIALIZED_NAME_FS_GROUP = "fsGroup";
    @SerializedName(value="fsGroup")
    private Long fsGroup;
    public static final String SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY = "fsGroupChangePolicy";
    @SerializedName(value="fsGroupChangePolicy")
    private String fsGroupChangePolicy;
    public static final String SERIALIZED_NAME_RUN_AS_GROUP = "runAsGroup";
    @SerializedName(value="runAsGroup")
    private Long runAsGroup;
    public static final String SERIALIZED_NAME_RUN_AS_NON_ROOT = "runAsNonRoot";
    @SerializedName(value="runAsNonRoot")
    private Boolean runAsNonRoot;
    public static final String SERIALIZED_NAME_RUN_AS_USER = "runAsUser";
    @SerializedName(value="runAsUser")
    private Long runAsUser;
    public static final String SERIALIZED_NAME_SE_LINUX_OPTIONS = "seLinuxOptions";
    @SerializedName(value="seLinuxOptions")
    private V1SELinuxOptions seLinuxOptions;
    public static final String SERIALIZED_NAME_SECCOMP_PROFILE = "seccompProfile";
    @SerializedName(value="seccompProfile")
    private V1SeccompProfile seccompProfile;
    public static final String SERIALIZED_NAME_SUPPLEMENTAL_GROUPS = "supplementalGroups";
    @SerializedName(value="supplementalGroups")
    private List<Long> supplementalGroups;
    public static final String SERIALIZED_NAME_SYSCTLS = "sysctls";
    @SerializedName(value="sysctls")
    private List<V1Sysctl> sysctls;
    public static final String SERIALIZED_NAME_WINDOWS_OPTIONS = "windowsOptions";
    @SerializedName(value="windowsOptions")
    private V1WindowsSecurityContextOptions windowsOptions;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodSecurityContext fsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return this;
    }

    @Nullable
    public Long getFsGroup() {
        return this.fsGroup;
    }

    public void setFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
    }

    public V1PodSecurityContext fsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return this;
    }

    @Nullable
    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public void setFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
    }

    public V1PodSecurityContext runAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    @Nullable
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public V1PodSecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @Nullable
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public V1PodSecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Nullable
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public V1PodSecurityContext seLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @Nullable
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public V1PodSecurityContext seccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    @Nullable
    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(V1SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public V1PodSecurityContext supplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
        return this;
    }

    public V1PodSecurityContext addSupplementalGroupsItem(Long supplementalGroupsItem) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(supplementalGroupsItem);
        return this;
    }

    @Nullable
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public V1PodSecurityContext sysctls(List<V1Sysctl> sysctls) {
        this.sysctls = sysctls;
        return this;
    }

    public V1PodSecurityContext addSysctlsItem(V1Sysctl sysctlsItem) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<V1Sysctl>();
        }
        this.sysctls.add(sysctlsItem);
        return this;
    }

    @Nullable
    public List<V1Sysctl> getSysctls() {
        return this.sysctls;
    }

    public void setSysctls(List<V1Sysctl> sysctls) {
        this.sysctls = sysctls;
    }

    public V1PodSecurityContext windowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    @Nullable
    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodSecurityContext v1PodSecurityContext = (V1PodSecurityContext)o;
        return Objects.equals(this.fsGroup, v1PodSecurityContext.fsGroup) && Objects.equals(this.fsGroupChangePolicy, v1PodSecurityContext.fsGroupChangePolicy) && Objects.equals(this.runAsGroup, v1PodSecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, v1PodSecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, v1PodSecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, v1PodSecurityContext.seLinuxOptions) && Objects.equals(this.seccompProfile, v1PodSecurityContext.seccompProfile) && Objects.equals(this.supplementalGroups, v1PodSecurityContext.supplementalGroups) && Objects.equals(this.sysctls, v1PodSecurityContext.sysctls) && Objects.equals(this.windowsOptions, v1PodSecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.sysctls, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodSecurityContext {\n");
        sb.append("    fsGroup: ").append(this.toIndentedString(this.fsGroup)).append("\n");
        sb.append("    fsGroupChangePolicy: ").append(this.toIndentedString(this.fsGroupChangePolicy)).append("\n");
        sb.append("    runAsGroup: ").append(this.toIndentedString(this.runAsGroup)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("    seccompProfile: ").append(this.toIndentedString(this.seccompProfile)).append("\n");
        sb.append("    supplementalGroups: ").append(this.toIndentedString(this.supplementalGroups)).append("\n");
        sb.append("    sysctls: ").append(this.toIndentedString(this.sysctls)).append("\n");
        sb.append("    windowsOptions: ").append(this.toIndentedString(this.windowsOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysysctls;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodSecurityContext is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodSecurityContext` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsGroupChangePolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SE_LINUX_OPTIONS).isJsonNull()) {
            V1SELinuxOptions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SE_LINUX_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE).isJsonNull()) {
            V1SeccompProfile.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SECCOMP_PROFILE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `supplementalGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYSCTLS) != null && !jsonObj.get(SERIALIZED_NAME_SYSCTLS).isJsonNull() && (jsonArraysysctls = jsonObj.getAsJsonArray(SERIALIZED_NAME_SYSCTLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SYSCTLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `sysctls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYSCTLS).toString()));
            }
            for (int i = 0; i < jsonArraysysctls.size(); ++i) {
                V1Sysctl.validateJsonObject(jsonArraysysctls.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_WINDOWS_OPTIONS).isJsonNull()) {
            V1WindowsSecurityContextOptions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WINDOWS_OPTIONS));
        }
    }

    public static V1PodSecurityContext fromJson(String jsonString) throws IOException {
        return (V1PodSecurityContext)JSON.getGson().fromJson(jsonString, V1PodSecurityContext.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FS_GROUP);
        openapiFields.add(SERIALIZED_NAME_FS_GROUP_CHANGE_POLICY);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_GROUP);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_NON_ROOT);
        openapiFields.add(SERIALIZED_NAME_RUN_AS_USER);
        openapiFields.add(SERIALIZED_NAME_SE_LINUX_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_PROFILE);
        openapiFields.add(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS);
        openapiFields.add(SERIALIZED_NAME_SYSCTLS);
        openapiFields.add(SERIALIZED_NAME_WINDOWS_OPTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodSecurityContext.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodSecurityContext.class));
            return new TypeAdapter<V1PodSecurityContext>(){

                public void write(JsonWriter out, V1PodSecurityContext value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodSecurityContext read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1PodSecurityContext.validateJsonObject(jsonObj);
                    return (V1PodSecurityContext)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

