/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1alpha2ResourceHandle;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1alpha2AllocationResult {
    public static final String SERIALIZED_NAME_AVAILABLE_ON_NODES = "availableOnNodes";
    @SerializedName(value="availableOnNodes")
    private V1NodeSelector availableOnNodes;
    public static final String SERIALIZED_NAME_RESOURCE_HANDLES = "resourceHandles";
    @SerializedName(value="resourceHandles")
    private List<V1alpha2ResourceHandle> resourceHandles;
    public static final String SERIALIZED_NAME_SHAREABLE = "shareable";
    @SerializedName(value="shareable")
    private Boolean shareable;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha2AllocationResult availableOnNodes(V1NodeSelector availableOnNodes) {
        this.availableOnNodes = availableOnNodes;
        return this;
    }

    @Nullable
    public V1NodeSelector getAvailableOnNodes() {
        return this.availableOnNodes;
    }

    public void setAvailableOnNodes(V1NodeSelector availableOnNodes) {
        this.availableOnNodes = availableOnNodes;
    }

    public V1alpha2AllocationResult resourceHandles(List<V1alpha2ResourceHandle> resourceHandles) {
        this.resourceHandles = resourceHandles;
        return this;
    }

    public V1alpha2AllocationResult addResourceHandlesItem(V1alpha2ResourceHandle resourceHandlesItem) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList<V1alpha2ResourceHandle>();
        }
        this.resourceHandles.add(resourceHandlesItem);
        return this;
    }

    @Nullable
    public List<V1alpha2ResourceHandle> getResourceHandles() {
        return this.resourceHandles;
    }

    public void setResourceHandles(List<V1alpha2ResourceHandle> resourceHandles) {
        this.resourceHandles = resourceHandles;
    }

    public V1alpha2AllocationResult shareable(Boolean shareable) {
        this.shareable = shareable;
        return this;
    }

    @Nullable
    public Boolean getShareable() {
        return this.shareable;
    }

    public void setShareable(Boolean shareable) {
        this.shareable = shareable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2AllocationResult v1alpha2AllocationResult = (V1alpha2AllocationResult)o;
        return Objects.equals(this.availableOnNodes, v1alpha2AllocationResult.availableOnNodes) && Objects.equals(this.resourceHandles, v1alpha2AllocationResult.resourceHandles) && Objects.equals(this.shareable, v1alpha2AllocationResult.shareable);
    }

    public int hashCode() {
        return Objects.hash(this.availableOnNodes, this.resourceHandles, this.shareable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2AllocationResult {\n");
        sb.append("    availableOnNodes: ").append(this.toIndentedString(this.availableOnNodes)).append("\n");
        sb.append("    resourceHandles: ").append(this.toIndentedString(this.resourceHandles)).append("\n");
        sb.append("    shareable: ").append(this.toIndentedString(this.shareable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayresourceHandles;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha2AllocationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha2AllocationResult` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AVAILABLE_ON_NODES) != null && !jsonObj.get(SERIALIZED_NAME_AVAILABLE_ON_NODES).isJsonNull()) {
            V1NodeSelector.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AVAILABLE_ON_NODES));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_HANDLES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_HANDLES).isJsonNull() && (jsonArrayresourceHandles = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCE_HANDLES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_HANDLES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resourceHandles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_HANDLES).toString()));
            }
            for (int i = 0; i < jsonArrayresourceHandles.size(); ++i) {
                V1alpha2ResourceHandle.validateJsonObject(jsonArrayresourceHandles.get(i).getAsJsonObject());
            }
        }
    }

    public static V1alpha2AllocationResult fromJson(String jsonString) throws IOException {
        return (V1alpha2AllocationResult)JSON.getGson().fromJson(jsonString, V1alpha2AllocationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE_ON_NODES);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_HANDLES);
        openapiFields.add(SERIALIZED_NAME_SHAREABLE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha2AllocationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha2AllocationResult.class));
            return new TypeAdapter<V1alpha2AllocationResult>(){

                public void write(JsonWriter out, V1alpha2AllocationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha2AllocationResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1alpha2AllocationResult.validateJsonObject(jsonObj);
                    return (V1alpha2AllocationResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

