/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.CoreV1EventSeries;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.")
public class CoreV1Event
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private String action;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    private OffsetDateTime eventTime;
    public static final String SERIALIZED_NAME_FIRST_TIMESTAMP = "firstTimestamp";
    @SerializedName(value="firstTimestamp")
    private OffsetDateTime firstTimestamp;
    public static final String SERIALIZED_NAME_INVOLVED_OBJECT = "involvedObject";
    @SerializedName(value="involvedObject")
    private V1ObjectReference involvedObject;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_LAST_TIMESTAMP = "lastTimestamp";
    @SerializedName(value="lastTimestamp")
    private OffsetDateTime lastTimestamp;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_RELATED = "related";
    @SerializedName(value="related")
    private V1ObjectReference related;
    public static final String SERIALIZED_NAME_REPORTING_COMPONENT = "reportingComponent";
    @SerializedName(value="reportingComponent")
    private String reportingComponent;
    public static final String SERIALIZED_NAME_REPORTING_INSTANCE = "reportingInstance";
    @SerializedName(value="reportingInstance")
    private String reportingInstance;
    public static final String SERIALIZED_NAME_SERIES = "series";
    @SerializedName(value="series")
    private CoreV1EventSeries series;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private V1EventSource source;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CoreV1Event action(String action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="What action was taken/failed regarding to the Regarding object.")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public CoreV1Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public CoreV1Event count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times this event has occurred.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public CoreV1Event eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time when this Event was first observed.")
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public CoreV1Event firstTimestamp(OffsetDateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)")
    public OffsetDateTime getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public void setFirstTimestamp(OffsetDateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
    }

    public CoreV1Event involvedObject(V1ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1ObjectReference getInvolvedObject() {
        return this.involvedObject;
    }

    public void setInvolvedObject(V1ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
    }

    public CoreV1Event kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public CoreV1Event lastTimestamp(OffsetDateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time at which the most recent occurrence of this event was recorded.")
    public OffsetDateTime getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(OffsetDateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public CoreV1Event message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable description of the status of this operation.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CoreV1Event metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public CoreV1Event reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This should be a short, machine understandable string that gives the reason for the transition into the object's current status.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public CoreV1Event related(V1ObjectReference related) {
        this.related = related;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getRelated() {
        return this.related;
    }

    public void setRelated(V1ObjectReference related) {
        this.related = related;
    }

    public CoreV1Event reportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.")
    public String getReportingComponent() {
        return this.reportingComponent;
    }

    public void setReportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
    }

    public CoreV1Event reportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the controller instance, e.g. `kubelet-xyzf`.")
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public void setReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
    }

    public CoreV1Event series(CoreV1EventSeries series) {
        this.series = series;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CoreV1EventSeries getSeries() {
        return this.series;
    }

    public void setSeries(CoreV1EventSeries series) {
        this.series = series;
    }

    public CoreV1Event source(V1EventSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EventSource getSource() {
        return this.source;
    }

    public void setSource(V1EventSource source) {
        this.source = source;
    }

    public CoreV1Event type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of this event (Normal, Warning), new types could be added in the future")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreV1Event coreV1Event = (CoreV1Event)o;
        return Objects.equals(this.action, coreV1Event.action) && Objects.equals(this.apiVersion, coreV1Event.apiVersion) && Objects.equals(this.count, coreV1Event.count) && Objects.equals(this.eventTime, coreV1Event.eventTime) && Objects.equals(this.firstTimestamp, coreV1Event.firstTimestamp) && Objects.equals(this.involvedObject, coreV1Event.involvedObject) && Objects.equals(this.kind, coreV1Event.kind) && Objects.equals(this.lastTimestamp, coreV1Event.lastTimestamp) && Objects.equals(this.message, coreV1Event.message) && Objects.equals(this.metadata, coreV1Event.metadata) && Objects.equals(this.reason, coreV1Event.reason) && Objects.equals(this.related, coreV1Event.related) && Objects.equals(this.reportingComponent, coreV1Event.reportingComponent) && Objects.equals(this.reportingInstance, coreV1Event.reportingInstance) && Objects.equals(this.series, coreV1Event.series) && Objects.equals(this.source, coreV1Event.source) && Objects.equals(this.type, coreV1Event.type);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.count, this.eventTime, this.firstTimestamp, this.involvedObject, this.kind, this.lastTimestamp, this.message, this.metadata, this.reason, this.related, this.reportingComponent, this.reportingInstance, this.series, this.source, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoreV1Event {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    firstTimestamp: ").append(this.toIndentedString(this.firstTimestamp)).append("\n");
        sb.append("    involvedObject: ").append(this.toIndentedString(this.involvedObject)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    lastTimestamp: ").append(this.toIndentedString(this.lastTimestamp)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    related: ").append(this.toIndentedString(this.related)).append("\n");
        sb.append("    reportingComponent: ").append(this.toIndentedString(this.reportingComponent)).append("\n");
        sb.append("    reportingInstance: ").append(this.toIndentedString(this.reportingInstance)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CoreV1Event is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CoreV1Event` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACTION) != null && !jsonObj.get(SERIALIZED_NAME_ACTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `action` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INVOLVED_OBJECT));
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
        V1ObjectMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RELATED) != null && !jsonObj.get(SERIALIZED_NAME_RELATED).isJsonNull()) {
            V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RELATED));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPORTING_COMPONENT) != null && !jsonObj.get(SERIALIZED_NAME_REPORTING_COMPONENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPORTING_COMPONENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reportingComponent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPORTING_COMPONENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE) != null && !jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reportingInstance` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERIES) != null && !jsonObj.get(SERIALIZED_NAME_SERIES).isJsonNull()) {
            CoreV1EventSeries.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SERIES));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonNull()) {
            V1EventSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static CoreV1Event fromJson(String jsonString) throws IOException {
        return (CoreV1Event)JSON.getGson().fromJson(jsonString, CoreV1Event.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_COUNT);
        openapiFields.add(SERIALIZED_NAME_EVENT_TIME);
        openapiFields.add(SERIALIZED_NAME_FIRST_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_INVOLVED_OBJECT);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_LAST_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_RELATED);
        openapiFields.add(SERIALIZED_NAME_REPORTING_COMPONENT);
        openapiFields.add(SERIALIZED_NAME_REPORTING_INSTANCE);
        openapiFields.add(SERIALIZED_NAME_SERIES);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_INVOLVED_OBJECT);
        openapiRequiredFields.add(SERIALIZED_NAME_METADATA);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CoreV1Event.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CoreV1Event.class));
            return new TypeAdapter<CoreV1Event>(){

                public void write(JsonWriter out, CoreV1Event value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CoreV1Event read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CoreV1Event.validateJsonElement(jsonElement);
                    return (CoreV1Event)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

