/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Adds and removes POSIX capabilities from running containers.")
public class V1Capabilities {
    public static final String SERIALIZED_NAME_ADD = "add";
    @SerializedName(value="add")
    private List<String> add = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DROP = "drop";
    @SerializedName(value="drop")
    private List<String> drop = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1Capabilities add(List<String> add) {
        this.add = add;
        return this;
    }

    public V1Capabilities addAddItem(String addItem) {
        if (this.add == null) {
            this.add = new ArrayList<String>();
        }
        this.add.add(addItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Added capabilities")
    public List<String> getAdd() {
        return this.add;
    }

    public void setAdd(List<String> add) {
        this.add = add;
    }

    public V1Capabilities drop(List<String> drop) {
        this.drop = drop;
        return this;
    }

    public V1Capabilities addDropItem(String dropItem) {
        if (this.drop == null) {
            this.drop = new ArrayList<String>();
        }
        this.drop.add(dropItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Removed capabilities")
    public List<String> getDrop() {
        return this.drop;
    }

    public void setDrop(List<String> drop) {
        this.drop = drop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Capabilities v1Capabilities = (V1Capabilities)o;
        return Objects.equals(this.add, v1Capabilities.add) && Objects.equals(this.drop, v1Capabilities.drop);
    }

    public int hashCode() {
        return Objects.hash(this.add, this.drop);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Capabilities {\n");
        sb.append("    add: ").append(this.toIndentedString(this.add)).append("\n");
        sb.append("    drop: ").append(this.toIndentedString(this.drop)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1Capabilities is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1Capabilities` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADD) != null && !jsonObj.get(SERIALIZED_NAME_ADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `add` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DROP) != null && !jsonObj.get(SERIALIZED_NAME_DROP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DROP).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `drop` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DROP).toString()));
        }
    }

    public static V1Capabilities fromJson(String jsonString) throws IOException {
        return (V1Capabilities)JSON.getGson().fromJson(jsonString, V1Capabilities.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADD);
        openapiFields.add(SERIALIZED_NAME_DROP);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1Capabilities.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1Capabilities.class));
            return new TypeAdapter<V1Capabilities>(){

                public void write(JsonWriter out, V1Capabilities value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1Capabilities read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1Capabilities.validateJsonElement(jsonElement);
                    return (V1Capabilities)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

