/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==\"\"`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.")
public class V1ResourcePolicyRule {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    private List<String> apiGroups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CLUSTER_SCOPE = "clusterScope";
    @SerializedName(value="clusterScope")
    private Boolean clusterScope;
    public static final String SERIALIZED_NAME_NAMESPACES = "namespaces";
    @SerializedName(value="namespaces")
    private List<String> namespaces = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERBS = "verbs";
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourcePolicyRule apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1ResourcePolicyRule addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`apiGroups` is a list of matching API groups and may not be empty. \"*\" matches all API groups and, if present, must be the only entry. Required.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1ResourcePolicyRule clusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.")
    public Boolean getClusterScope() {
        return this.clusterScope;
    }

    public void setClusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
    }

    public V1ResourcePolicyRule namespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public V1ResourcePolicyRule addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains \"*\".  Note that \"*\" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.")
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public V1ResourcePolicyRule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1ResourcePolicyRule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ \"services\", \"nodes/status\" ].  This list may not be empty. \"*\" matches all resources and, if present, must be the only entry. Required.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public V1ResourcePolicyRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1ResourcePolicyRule addVerbsItem(String verbsItem) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(verbsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`verbs` is a list of matching verbs and may not be empty. \"*\" matches all verbs and, if present, must be the only entry. Required.")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourcePolicyRule v1ResourcePolicyRule = (V1ResourcePolicyRule)o;
        return Objects.equals(this.apiGroups, v1ResourcePolicyRule.apiGroups) && Objects.equals(this.clusterScope, v1ResourcePolicyRule.clusterScope) && Objects.equals(this.namespaces, v1ResourcePolicyRule.namespaces) && Objects.equals(this.resources, v1ResourcePolicyRule.resources) && Objects.equals(this.verbs, v1ResourcePolicyRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.clusterScope, this.namespaces, this.resources, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourcePolicyRule {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    clusterScope: ").append(this.toIndentedString(this.clusterScope)).append("\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourcePolicyRule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourcePolicyRule` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_GROUPS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_API_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACES) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespaces` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERBS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERBS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `verbs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERBS).toString()));
        }
    }

    public static V1ResourcePolicyRule fromJson(String jsonString) throws IOException {
        return (V1ResourcePolicyRule)JSON.getGson().fromJson(jsonString, V1ResourcePolicyRule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_GROUPS);
        openapiFields.add(SERIALIZED_NAME_CLUSTER_SCOPE);
        openapiFields.add(SERIALIZED_NAME_NAMESPACES);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_VERBS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_API_GROUPS);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCES);
        openapiRequiredFields.add(SERIALIZED_NAME_VERBS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourcePolicyRule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourcePolicyRule.class));
            return new TypeAdapter<V1ResourcePolicyRule>(){

                public void write(JsonWriter out, V1ResourcePolicyRule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourcePolicyRule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ResourcePolicyRule.validateJsonElement(jsonElement);
                    return (V1ResourcePolicyRule)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

