/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceQuotaStatus defines the enforced hard limits and observed use.")
public class V1ResourceQuotaStatus {
    public static final String SERIALIZED_NAME_HARD = "hard";
    @SerializedName(value="hard")
    private Map<String, Quantity> hard = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_USED = "used";
    @SerializedName(value="used")
    private Map<String, Quantity> used = new HashMap<String, Quantity>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourceQuotaStatus hard(Map<String, Quantity> hard) {
        this.hard = hard;
        return this;
    }

    public V1ResourceQuotaStatus putHardItem(String key, Quantity hardItem) {
        if (this.hard == null) {
            this.hard = new HashMap<String, Quantity>();
        }
        this.hard.put(key, hardItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/")
    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    public void setHard(Map<String, Quantity> hard) {
        this.hard = hard;
    }

    public V1ResourceQuotaStatus used(Map<String, Quantity> used) {
        this.used = used;
        return this;
    }

    public V1ResourceQuotaStatus putUsedItem(String key, Quantity usedItem) {
        if (this.used == null) {
            this.used = new HashMap<String, Quantity>();
        }
        this.used.put(key, usedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used is the current observed total usage of the resource in the namespace.")
    public Map<String, Quantity> getUsed() {
        return this.used;
    }

    public void setUsed(Map<String, Quantity> used) {
        this.used = used;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceQuotaStatus v1ResourceQuotaStatus = (V1ResourceQuotaStatus)o;
        return Objects.equals(this.hard, v1ResourceQuotaStatus.hard) && Objects.equals(this.used, v1ResourceQuotaStatus.used);
    }

    public int hashCode() {
        return Objects.hash(this.hard, this.used);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceQuotaStatus {\n");
        sb.append("    hard: ").append(this.toIndentedString(this.hard)).append("\n");
        sb.append("    used: ").append(this.toIndentedString(this.used)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourceQuotaStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourceQuotaStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
    }

    public static V1ResourceQuotaStatus fromJson(String jsonString) throws IOException {
        return (V1ResourceQuotaStatus)JSON.getGson().fromJson(jsonString, V1ResourceQuotaStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HARD);
        openapiFields.add(SERIALIZED_NAME_USED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourceQuotaStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourceQuotaStatus.class));
            return new TypeAdapter<V1ResourceQuotaStatus>(){

                public void write(JsonWriter out, V1ResourceQuotaStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourceQuotaStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ResourceQuotaStatus.validateJsonElement(jsonElement);
                    return (V1ResourceQuotaStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

