/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta1DeviceAllocationConfiguration;
import io.kubernetes.client.openapi.models.V1beta1DeviceRequestAllocationResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceAllocationResult is the result of allocating devices.")
public class V1beta1DeviceAllocationResult {
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private List<V1beta1DeviceAllocationConfiguration> config = new ArrayList<V1beta1DeviceAllocationConfiguration>();
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private List<V1beta1DeviceRequestAllocationResult> results = new ArrayList<V1beta1DeviceRequestAllocationResult>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1DeviceAllocationResult config(List<V1beta1DeviceAllocationConfiguration> config) {
        this.config = config;
        return this;
    }

    public V1beta1DeviceAllocationResult addConfigItem(V1beta1DeviceAllocationConfiguration configItem) {
        if (this.config == null) {
            this.config = new ArrayList<V1beta1DeviceAllocationConfiguration>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This field is a combination of all the claim and class configuration parameters. Drivers can distinguish between those based on a flag.  This includes configuration parameters for drivers which have no allocated devices in the result because it is up to the drivers which configuration parameters they support. They can silently ignore unknown configuration parameters.")
    public List<V1beta1DeviceAllocationConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(List<V1beta1DeviceAllocationConfiguration> config) {
        this.config = config;
    }

    public V1beta1DeviceAllocationResult results(List<V1beta1DeviceRequestAllocationResult> results) {
        this.results = results;
        return this;
    }

    public V1beta1DeviceAllocationResult addResultsItem(V1beta1DeviceRequestAllocationResult resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<V1beta1DeviceRequestAllocationResult>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Results lists all allocated devices.")
    public List<V1beta1DeviceRequestAllocationResult> getResults() {
        return this.results;
    }

    public void setResults(List<V1beta1DeviceRequestAllocationResult> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceAllocationResult v1beta1DeviceAllocationResult = (V1beta1DeviceAllocationResult)o;
        return Objects.equals(this.config, v1beta1DeviceAllocationResult.config) && Objects.equals(this.results, v1beta1DeviceAllocationResult.results);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceAllocationResult {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayresults;
        int i;
        JsonArray jsonArrayconfig;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1DeviceAllocationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1DeviceAllocationResult` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull() && (jsonArrayconfig = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFIG)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `config` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIG).toString()));
            }
            for (i = 0; i < jsonArrayconfig.size(); ++i) {
                V1beta1DeviceAllocationConfiguration.validateJsonElement(jsonArrayconfig.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULTS) != null && !jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonNull() && (jsonArrayresults = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESULTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULTS).toString()));
            }
            for (i = 0; i < jsonArrayresults.size(); ++i) {
                V1beta1DeviceRequestAllocationResult.validateJsonElement(jsonArrayresults.get(i));
            }
        }
    }

    public static V1beta1DeviceAllocationResult fromJson(String jsonString) throws IOException {
        return (V1beta1DeviceAllocationResult)JSON.getGson().fromJson(jsonString, V1beta1DeviceAllocationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1DeviceAllocationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1DeviceAllocationResult.class));
            return new TypeAdapter<V1beta1DeviceAllocationResult>(){

                public void write(JsonWriter out, V1beta1DeviceAllocationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1DeviceAllocationResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1DeviceAllocationResult.validateJsonElement(jsonElement);
                    return (V1beta1DeviceAllocationResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

