/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerCondition;
import io.kubernetes.client.openapi.models.V2MetricStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.")
public class V2HorizontalPodAutoscalerStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V2HorizontalPodAutoscalerCondition> conditions = new ArrayList<V2HorizontalPodAutoscalerCondition>();
    public static final String SERIALIZED_NAME_CURRENT_METRICS = "currentMetrics";
    @SerializedName(value="currentMetrics")
    private List<V2MetricStatus> currentMetrics = new ArrayList<V2MetricStatus>();
    public static final String SERIALIZED_NAME_CURRENT_REPLICAS = "currentReplicas";
    @SerializedName(value="currentReplicas")
    private Integer currentReplicas;
    public static final String SERIALIZED_NAME_DESIRED_REPLICAS = "desiredReplicas";
    @SerializedName(value="desiredReplicas")
    private Integer desiredReplicas;
    public static final String SERIALIZED_NAME_LAST_SCALE_TIME = "lastScaleTime";
    @SerializedName(value="lastScaleTime")
    private OffsetDateTime lastScaleTime;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2HorizontalPodAutoscalerStatus conditions(List<V2HorizontalPodAutoscalerCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V2HorizontalPodAutoscalerStatus addConditionsItem(V2HorizontalPodAutoscalerCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V2HorizontalPodAutoscalerCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.")
    public List<V2HorizontalPodAutoscalerCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V2HorizontalPodAutoscalerCondition> conditions) {
        this.conditions = conditions;
    }

    public V2HorizontalPodAutoscalerStatus currentMetrics(List<V2MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
        return this;
    }

    public V2HorizontalPodAutoscalerStatus addCurrentMetricsItem(V2MetricStatus currentMetricsItem) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<V2MetricStatus>();
        }
        this.currentMetrics.add(currentMetricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentMetrics is the last read state of the metrics used by this autoscaler.")
    public List<V2MetricStatus> getCurrentMetrics() {
        return this.currentMetrics;
    }

    public void setCurrentMetrics(List<V2MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
    }

    public V2HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.")
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V2HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.")
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public V2HorizontalPodAutoscalerStatus lastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.")
    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public V2HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration is the most recent generation observed by this autoscaler.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerStatus v2HorizontalPodAutoscalerStatus = (V2HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.conditions, v2HorizontalPodAutoscalerStatus.conditions) && Objects.equals(this.currentMetrics, v2HorizontalPodAutoscalerStatus.currentMetrics) && Objects.equals(this.currentReplicas, v2HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.desiredReplicas, v2HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.lastScaleTime, v2HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, v2HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2HorizontalPodAutoscalerStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentMetrics: ").append(this.toIndentedString(this.currentMetrics)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    desiredReplicas: ").append(this.toIndentedString(this.desiredReplicas)).append("\n");
        sb.append("    lastScaleTime: ").append(this.toIndentedString(this.lastScaleTime)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycurrentMetrics;
        int i;
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2HorizontalPodAutoscalerStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2HorizontalPodAutoscalerStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (i = 0; i < jsonArrayconditions.size(); ++i) {
                V2HorizontalPodAutoscalerCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENT_METRICS) != null && !jsonObj.get(SERIALIZED_NAME_CURRENT_METRICS).isJsonNull() && (jsonArraycurrentMetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_CURRENT_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CURRENT_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `currentMetrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENT_METRICS).toString()));
            }
            for (i = 0; i < jsonArraycurrentMetrics.size(); ++i) {
                V2MetricStatus.validateJsonElement(jsonArraycurrentMetrics.get(i));
            }
        }
    }

    public static V2HorizontalPodAutoscalerStatus fromJson(String jsonString) throws IOException {
        return (V2HorizontalPodAutoscalerStatus)JSON.getGson().fromJson(jsonString, V2HorizontalPodAutoscalerStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_METRICS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_DESIRED_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_LAST_SCALE_TIME);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DESIRED_REPLICAS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2HorizontalPodAutoscalerStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2HorizontalPodAutoscalerStatus.class));
            return new TypeAdapter<V2HorizontalPodAutoscalerStatus>(){

                public void write(JsonWriter out, V2HorizontalPodAutoscalerStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2HorizontalPodAutoscalerStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2HorizontalPodAutoscalerStatus.validateJsonElement(jsonElement);
                    return (V2HorizontalPodAutoscalerStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

