/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.EventsV1Event;
import io.kubernetes.client.openapi.models.EventsV1EventBuilder;
import io.kubernetes.client.openapi.models.EventsV1EventFluentImpl;
import io.kubernetes.client.openapi.models.EventsV1EventList;
import io.kubernetes.client.openapi.models.EventsV1EventListFluent;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.openapi.models.V1ListMetaBuilder;
import io.kubernetes.client.openapi.models.V1ListMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class EventsV1EventListFluentImpl<A extends EventsV1EventListFluent<A>>
extends BaseFluent<A>
implements EventsV1EventListFluent<A> {
    private String apiVersion;
    private ArrayList<EventsV1EventBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public EventsV1EventListFluentImpl() {
    }

    public EventsV1EventListFluentImpl(EventsV1EventList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(Integer index, EventsV1Event item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        EventsV1EventBuilder builder = new EventsV1EventBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, EventsV1Event item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        EventsV1EventBuilder builder = new EventsV1EventBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(EventsV1Event ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (EventsV1Event item : items) {
            EventsV1EventBuilder builder = new EventsV1EventBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<EventsV1Event> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (EventsV1Event item : items) {
            EventsV1EventBuilder builder = new EventsV1EventBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(EventsV1Event ... items) {
        for (EventsV1Event item : items) {
            EventsV1EventBuilder builder = new EventsV1EventBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<EventsV1Event> items) {
        for (EventsV1Event item : items) {
            EventsV1EventBuilder builder = new EventsV1EventBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<EventsV1EventBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<EventsV1EventBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            EventsV1EventBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EventsV1Event> getItems() {
        return this.items != null ? EventsV1EventListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<EventsV1Event> buildItems() {
        return this.items != null ? EventsV1EventListFluentImpl.build(this.items) : null;
    }

    @Override
    public EventsV1Event buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public EventsV1Event buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public EventsV1Event buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public EventsV1Event buildMatchingItem(Predicate<EventsV1EventBuilder> predicate) {
        for (EventsV1EventBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<EventsV1EventBuilder> predicate) {
        for (EventsV1EventBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<EventsV1Event> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList();
            for (EventsV1Event item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(EventsV1Event ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (EventsV1Event item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> addNewItemLike(EventsV1Event item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> setNewItemLike(Integer index, EventsV1Event item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public EventsV1EventListFluent.ItemsNested<A> editMatchingItem(Predicate<EventsV1EventBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ListMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EventsV1EventListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EventsV1EventListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EventsV1EventListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EventsV1EventListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ListMetaBuilder().build());
    }

    @Override
    public EventsV1EventListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsV1EventListFluentImpl that = (EventsV1EventListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends V1ListMetaFluentImpl<EventsV1EventListFluent.MetadataNested<N>>
    implements EventsV1EventListFluent.MetadataNested<N>,
    Nested<N> {
        V1ListMetaBuilder builder;

        MetadataNestedImpl(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventsV1EventListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ItemsNestedImpl<N>
    extends EventsV1EventFluentImpl<EventsV1EventListFluent.ItemsNested<N>>
    implements EventsV1EventListFluent.ItemsNested<N>,
    Nested<N> {
        EventsV1EventBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, EventsV1Event item) {
            this.index = index;
            this.builder = new EventsV1EventBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new EventsV1EventBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventsV1EventListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

