/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1ValidatingWebhook;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookBuilder;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookConfiguration;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookConfigurationFluent;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ValidatingWebhookConfigurationFluentImpl<A extends V1ValidatingWebhookConfigurationFluent<A>>
extends BaseFluent<A>
implements V1ValidatingWebhookConfigurationFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<V1ValidatingWebhookBuilder> webhooks;

    public V1ValidatingWebhookConfigurationFluentImpl() {
    }

    public V1ValidatingWebhookConfigurationFluentImpl(V1ValidatingWebhookConfiguration instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withWebhooks(instance.getWebhooks());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToWebhooks(Integer index, V1ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
        this._visitables.get("webhooks").add(index >= 0 ? index.intValue() : this._visitables.get("webhooks").size(), builder);
        this.webhooks.add(index >= 0 ? index.intValue() : this.webhooks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWebhooks(Integer index, V1ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
        if (index < 0 || index >= this._visitables.get("webhooks").size()) {
            this._visitables.get("webhooks").add(builder);
        } else {
            this._visitables.get("webhooks").set(index, builder);
        }
        if (index < 0 || index >= this.webhooks.size()) {
            this.webhooks.add(builder);
        } else {
            this.webhooks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWebhooks(V1ValidatingWebhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWebhooks(Collection<V1ValidatingWebhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWebhooks(V1ValidatingWebhook ... items) {
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWebhooks(Collection<V1ValidatingWebhook> items) {
        for (V1ValidatingWebhook item : items) {
            V1ValidatingWebhookBuilder builder = new V1ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWebhooks(Predicate<V1ValidatingWebhookBuilder> predicate) {
        if (this.webhooks == null) {
            return (A)this;
        }
        Iterator<V1ValidatingWebhookBuilder> each = this.webhooks.iterator();
        Object visitables = this._visitables.get("webhooks");
        while (each.hasNext()) {
            V1ValidatingWebhookBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ValidatingWebhook> getWebhooks() {
        return this.webhooks != null ? V1ValidatingWebhookConfigurationFluentImpl.build(this.webhooks) : null;
    }

    @Override
    public List<V1ValidatingWebhook> buildWebhooks() {
        return this.webhooks != null ? V1ValidatingWebhookConfigurationFluentImpl.build(this.webhooks) : null;
    }

    @Override
    public V1ValidatingWebhook buildWebhook(Integer index) {
        return this.webhooks.get(index).build();
    }

    @Override
    public V1ValidatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    @Override
    public V1ValidatingWebhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    @Override
    public V1ValidatingWebhook buildMatchingWebhook(Predicate<V1ValidatingWebhookBuilder> predicate) {
        for (V1ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWebhook(Predicate<V1ValidatingWebhookBuilder> predicate) {
        for (V1ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWebhooks(List<V1ValidatingWebhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get("webhooks").removeAll(this.webhooks);
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList();
            for (V1ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)this;
    }

    @Override
    public A withWebhooks(V1ValidatingWebhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
        }
        if (webhooks != null) {
            for (V1ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new WebhooksNestedImpl();
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(V1ValidatingWebhook item) {
        return new WebhooksNestedImpl(-1, item);
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(Integer index, V1ValidatingWebhook item) {
        return new WebhooksNestedImpl(index, item);
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(Integer index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public V1ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(Predicate<V1ValidatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.test(this.webhooks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ValidatingWebhookConfigurationFluentImpl that = (V1ValidatingWebhookConfigurationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.webhooks != null ? !this.webhooks.equals(that.webhooks) : that.webhooks != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.webhooks != null && !this.webhooks.isEmpty()) {
            sb.append("webhooks:");
            sb.append(this.webhooks);
        }
        sb.append("}");
        return sb.toString();
    }

    class WebhooksNestedImpl<N>
    extends V1ValidatingWebhookFluentImpl<V1ValidatingWebhookConfigurationFluent.WebhooksNested<N>>
    implements V1ValidatingWebhookConfigurationFluent.WebhooksNested<N>,
    Nested<N> {
        V1ValidatingWebhookBuilder builder;
        Integer index;

        WebhooksNestedImpl(Integer index, V1ValidatingWebhook item) {
            this.index = index;
            this.builder = new V1ValidatingWebhookBuilder(this, item);
        }

        WebhooksNestedImpl() {
            this.index = -1;
            this.builder = new V1ValidatingWebhookBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(this.index, this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ValidatingWebhookConfigurationFluent.MetadataNested<N>>
    implements V1ValidatingWebhookConfigurationFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookConfigurationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

