/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1beta1RuntimeClassStrategyOptions;
import io.kubernetes.client.openapi.models.V1beta1RuntimeClassStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1beta1RuntimeClassStrategyOptionsFluentImpl<A extends V1beta1RuntimeClassStrategyOptionsFluent<A>>
extends BaseFluent<A>
implements V1beta1RuntimeClassStrategyOptionsFluent<A> {
    private List<String> allowedRuntimeClassNames;
    private String defaultRuntimeClassName;

    public V1beta1RuntimeClassStrategyOptionsFluentImpl() {
    }

    public V1beta1RuntimeClassStrategyOptionsFluentImpl(V1beta1RuntimeClassStrategyOptions instance) {
        this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());
        this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());
    }

    @Override
    public A addToAllowedRuntimeClassNames(Integer index, String item) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        this.allowedRuntimeClassNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedRuntimeClassNames(Integer index, String item) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        this.allowedRuntimeClassNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedRuntimeClassNames(String ... items) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedRuntimeClassNames(Collection<String> items) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedRuntimeClassNames(String ... items) {
        for (String item : items) {
            if (this.allowedRuntimeClassNames == null) continue;
            this.allowedRuntimeClassNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedRuntimeClassNames(Collection<String> items) {
        for (String item : items) {
            if (this.allowedRuntimeClassNames == null) continue;
            this.allowedRuntimeClassNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames;
    }

    @Override
    public String getAllowedRuntimeClassName(Integer index) {
        return this.allowedRuntimeClassNames.get(index);
    }

    @Override
    public String getFirstAllowedRuntimeClassName() {
        return this.allowedRuntimeClassNames.get(0);
    }

    @Override
    public String getLastAllowedRuntimeClassName() {
        return this.allowedRuntimeClassNames.get(this.allowedRuntimeClassNames.size() - 1);
    }

    @Override
    public String getMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
        for (String item : this.allowedRuntimeClassNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
        for (String item : this.allowedRuntimeClassNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
        if (allowedRuntimeClassNames != null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
            for (String item : allowedRuntimeClassNames) {
                this.addToAllowedRuntimeClassNames(item);
            }
        } else {
            this.allowedRuntimeClassNames = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedRuntimeClassNames(String ... allowedRuntimeClassNames) {
        if (this.allowedRuntimeClassNames != null) {
            this.allowedRuntimeClassNames.clear();
        }
        if (allowedRuntimeClassNames != null) {
            for (String item : allowedRuntimeClassNames) {
                this.addToAllowedRuntimeClassNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty();
    }

    @Override
    public String getDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName;
    }

    @Override
    public A withDefaultRuntimeClassName(String defaultRuntimeClassName) {
        this.defaultRuntimeClassName = defaultRuntimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1RuntimeClassStrategyOptionsFluentImpl that = (V1beta1RuntimeClassStrategyOptionsFluentImpl)o;
        if (this.allowedRuntimeClassNames != null ? !this.allowedRuntimeClassNames.equals(that.allowedRuntimeClassNames) : that.allowedRuntimeClassNames != null) {
            return false;
        }
        return !(this.defaultRuntimeClassName != null ? !this.defaultRuntimeClassName.equals(that.defaultRuntimeClassName) : that.defaultRuntimeClassName != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedRuntimeClassNames, this.defaultRuntimeClassName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty()) {
            sb.append("allowedRuntimeClassNames:");
            sb.append(this.allowedRuntimeClassNames + ",");
        }
        if (this.defaultRuntimeClassName != null) {
            sb.append("defaultRuntimeClassName:");
            sb.append(this.defaultRuntimeClassName);
        }
        sb.append("}");
        return sb.toString();
    }
}

