/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DaemonSetSpec;
import io.kubernetes.client.openapi.models.V1DaemonSetSpecFluent;
import io.kubernetes.client.openapi.models.V1DaemonSetUpdateStrategy;
import io.kubernetes.client.openapi.models.V1DaemonSetUpdateStrategyBuilder;
import io.kubernetes.client.openapi.models.V1DaemonSetUpdateStrategyFluentImpl;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluentImpl;
import java.util.Objects;

public class V1DaemonSetSpecFluentImpl<A extends V1DaemonSetSpecFluent<A>>
extends BaseFluent<A>
implements V1DaemonSetSpecFluent<A> {
    private Integer minReadySeconds;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private V1PodTemplateSpecBuilder template;
    private V1DaemonSetUpdateStrategyBuilder updateStrategy;

    public V1DaemonSetSpecFluentImpl() {
    }

    public V1DaemonSetSpecFluentImpl(V1DaemonSetSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V1DaemonSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V1DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V1DaemonSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V1DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public V1PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public V1DaemonSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public V1DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public V1DaemonSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public V1DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new V1PodTemplateSpecBuilder().build());
    }

    @Override
    public V1DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public V1DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public V1DaemonSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(V1DaemonSetUpdateStrategy updateStrategy) {
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new V1DaemonSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get("updateStrategy").remove(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public V1DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public V1DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1DaemonSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public V1DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public V1DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new V1DaemonSetUpdateStrategyBuilder().build());
    }

    @Override
    public V1DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1DaemonSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DaemonSetSpecFluentImpl that = (V1DaemonSetSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.updateStrategy != null ? !this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.revisionHistoryLimit, this.selector, this.template, this.updateStrategy, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append(this.updateStrategy);
        }
        sb.append("}");
        return sb.toString();
    }

    class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1DaemonSetSpecFluent.SelectorNested<N>>
    implements V1DaemonSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DaemonSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    class TemplateNestedImpl<N>
    extends V1PodTemplateSpecFluentImpl<V1DaemonSetSpecFluent.TemplateNested<N>>
    implements V1DaemonSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        V1PodTemplateSpecBuilder builder;

        TemplateNestedImpl(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new V1PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DaemonSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class UpdateStrategyNestedImpl<N>
    extends V1DaemonSetUpdateStrategyFluentImpl<V1DaemonSetSpecFluent.UpdateStrategyNested<N>>
    implements V1DaemonSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        V1DaemonSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(V1DaemonSetUpdateStrategy item) {
            this.builder = new V1DaemonSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new V1DaemonSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DaemonSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }
}

