/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscalerStatus;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscalerStatusFluent;
import java.time.OffsetDateTime;
import java.util.Objects;

public class V1HorizontalPodAutoscalerStatusFluentImpl<A extends V1HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A>
implements V1HorizontalPodAutoscalerStatusFluent<A> {
    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private OffsetDateTime lastScaleTime;
    private Long observedGeneration;

    public V1HorizontalPodAutoscalerStatusFluentImpl() {
    }

    public V1HorizontalPodAutoscalerStatusFluentImpl(V1HorizontalPodAutoscalerStatus instance) {
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    @Override
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage != null;
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    @Override
    public A withLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HorizontalPodAutoscalerStatusFluentImpl that = (V1HorizontalPodAutoscalerStatusFluentImpl)o;
        if (this.currentCPUUtilizationPercentage != null ? !this.currentCPUUtilizationPercentage.equals(that.currentCPUUtilizationPercentage) : that.currentCPUUtilizationPercentage != null) {
            return false;
        }
        if (this.currentReplicas != null ? !this.currentReplicas.equals(that.currentReplicas) : that.currentReplicas != null) {
            return false;
        }
        if (this.desiredReplicas != null ? !this.desiredReplicas.equals(that.desiredReplicas) : that.desiredReplicas != null) {
            return false;
        }
        if (this.lastScaleTime != null ? !this.lastScaleTime.equals(that.lastScaleTime) : that.lastScaleTime != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentCPUUtilizationPercentage, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentCPUUtilizationPercentage != null) {
            sb.append("currentCPUUtilizationPercentage:");
            sb.append(this.currentCPUUtilizationPercentage + ",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(this.lastScaleTime + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }
}

