/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1ServiceSpecBuilder;
import io.kubernetes.client.openapi.models.V1ServiceSpecFluent;
import io.kubernetes.client.openapi.models.V1ServiceStatus;
import io.kubernetes.client.openapi.models.V1ServiceStatusBuilder;
import io.kubernetes.client.openapi.models.V1ServiceStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class V1ServiceFluent<A extends V1ServiceFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1ServiceSpecBuilder spec;
    private V1ServiceStatusBuilder status;

    public V1ServiceFluent() {
    }

    public V1ServiceFluent(V1Service instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1Service instance) {
        V1Service v1Service = instance = instance != null ? instance : new V1Service();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1ServiceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(V1ServiceSpec spec) {
        this._visitables.remove("spec");
        if (spec != null) {
            this.spec = new V1ServiceSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(V1ServiceSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new V1ServiceSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(V1ServiceSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public V1ServiceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(V1ServiceStatus status) {
        this._visitables.remove("status");
        if (status != null) {
            this.status = new V1ServiceStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(V1ServiceStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new V1ServiceStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(V1ServiceStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServiceFluent that = (V1ServiceFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends V1ServiceSpecFluent<SpecNested<N>>
    implements Nested<N> {
        V1ServiceSpecBuilder builder;

        SpecNested(V1ServiceSpec item) {
            this.builder = new V1ServiceSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends V1ServiceStatusFluent<StatusNested<N>>
    implements Nested<N> {
        V1ServiceStatusBuilder builder;

        StatusNested(V1ServiceStatus item) {
            this.builder = new V1ServiceStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

