/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClass;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReferenceBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReferenceFluent;
import java.util.Objects;
import java.util.Optional;

public class V1alpha2ResourceClassFluent<A extends V1alpha2ResourceClassFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1alpha2ResourceClassParametersReferenceBuilder parametersRef;
    private V1NodeSelectorBuilder suitableNodes;

    public V1alpha2ResourceClassFluent() {
    }

    public V1alpha2ResourceClassFluent(V1alpha2ResourceClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2ResourceClass instance) {
        V1alpha2ResourceClass v1alpha2ResourceClass = instance = instance != null ? instance : new V1alpha2ResourceClass();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParametersRef(instance.getParametersRef());
            this.withSuitableNodes(instance.getSuitableNodes());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1alpha2ResourceClassParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    public A withParametersRef(V1alpha2ResourceClassParametersReference parametersRef) {
        this._visitables.remove("parametersRef");
        if (parametersRef != null) {
            this.parametersRef = new V1alpha2ResourceClassParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    public boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    public ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNested(null);
    }

    public ParametersRefNested<A> withNewParametersRefLike(V1alpha2ResourceClassParametersReference item) {
        return new ParametersRefNested(item);
    }

    public ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(null));
    }

    public ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(new V1alpha2ResourceClassParametersReferenceBuilder().build()));
    }

    public ParametersRefNested<A> editOrNewParametersRefLike(V1alpha2ResourceClassParametersReference item) {
        return this.withNewParametersRefLike(Optional.ofNullable(this.buildParametersRef()).orElse(item));
    }

    public V1NodeSelector buildSuitableNodes() {
        return this.suitableNodes != null ? this.suitableNodes.build() : null;
    }

    public A withSuitableNodes(V1NodeSelector suitableNodes) {
        this._visitables.remove("suitableNodes");
        if (suitableNodes != null) {
            this.suitableNodes = new V1NodeSelectorBuilder(suitableNodes);
            this._visitables.get("suitableNodes").add(this.suitableNodes);
        } else {
            this.suitableNodes = null;
            this._visitables.get("suitableNodes").remove(this.suitableNodes);
        }
        return (A)this;
    }

    public boolean hasSuitableNodes() {
        return this.suitableNodes != null;
    }

    public SuitableNodesNested<A> withNewSuitableNodes() {
        return new SuitableNodesNested(null);
    }

    public SuitableNodesNested<A> withNewSuitableNodesLike(V1NodeSelector item) {
        return new SuitableNodesNested(item);
    }

    public SuitableNodesNested<A> editSuitableNodes() {
        return this.withNewSuitableNodesLike(Optional.ofNullable(this.buildSuitableNodes()).orElse(null));
    }

    public SuitableNodesNested<A> editOrNewSuitableNodes() {
        return this.withNewSuitableNodesLike(Optional.ofNullable(this.buildSuitableNodes()).orElse(new V1NodeSelectorBuilder().build()));
    }

    public SuitableNodesNested<A> editOrNewSuitableNodesLike(V1NodeSelector item) {
        return this.withNewSuitableNodesLike(Optional.ofNullable(this.buildSuitableNodes()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClassFluent that = (V1alpha2ResourceClassFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        return Objects.equals(this.suitableNodes, that.suitableNodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parametersRef, this.suitableNodes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef + ",");
        }
        if (this.suitableNodes != null) {
            sb.append("suitableNodes:");
            sb.append(this.suitableNodes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ParametersRefNested<N>
    extends V1alpha2ResourceClassParametersReferenceFluent<ParametersRefNested<N>>
    implements Nested<N> {
        V1alpha2ResourceClassParametersReferenceBuilder builder;

        ParametersRefNested(V1alpha2ResourceClassParametersReference item) {
            this.builder = new V1alpha2ResourceClassParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassFluent.this.withParametersRef(this.builder.build());
        }

        public N endParametersRef() {
            return this.and();
        }
    }

    public class SuitableNodesNested<N>
    extends V1NodeSelectorFluent<SuitableNodesNested<N>>
    implements Nested<N> {
        V1NodeSelectorBuilder builder;

        SuitableNodesNested(V1NodeSelector item) {
            this.builder = new V1NodeSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassFluent.this.withSuitableNodes(this.builder.build());
        }

        public N endSuitableNodes() {
            return this.and();
        }
    }
}

