/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1TopologySpreadConstraintFluent<A extends V1TopologySpreadConstraintFluent<A>>
extends BaseFluent<A> {
    private V1LabelSelectorBuilder labelSelector;
    private List<String> matchLabelKeys;
    private Integer maxSkew;
    private Integer minDomains;
    private String nodeAffinityPolicy;
    private String nodeTaintsPolicy;
    private String topologyKey;
    private String whenUnsatisfiable;

    public V1TopologySpreadConstraintFluent() {
    }

    public V1TopologySpreadConstraintFluent(V1TopologySpreadConstraint instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1TopologySpreadConstraint instance) {
        V1TopologySpreadConstraint v1TopologySpreadConstraint = instance = instance != null ? instance : new V1TopologySpreadConstraint();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withMatchLabelKeys(instance.getMatchLabelKeys());
            this.withMaxSkew(instance.getMaxSkew());
            this.withMinDomains(instance.getMinDomains());
            this.withNodeAffinityPolicy(instance.getNodeAffinityPolicy());
            this.withNodeTaintsPolicy(instance.getNodeTaintsPolicy());
            this.withTopologyKey(instance.getTopologyKey());
            this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable());
        }
    }

    public V1LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    public A withLabelSelector(V1LabelSelector labelSelector) {
        this._visitables.remove("labelSelector");
        if (labelSelector != null) {
            this.labelSelector = new V1LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get("labelSelector").remove(this.labelSelector);
        }
        return (A)this;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(V1LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(V1LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public A addToMatchLabelKeys(int index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.add(index, item);
        return (A)this;
    }

    public A setToMatchLabelKeys(int index, String item) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.set(index, item);
        return (A)this;
    }

    public A addToMatchLabelKeys(String ... items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    public A addAllToMatchLabelKeys(Collection<String> items) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.matchLabelKeys.add(item);
        }
        return (A)this;
    }

    public A removeFromMatchLabelKeys(String ... items) {
        if (this.matchLabelKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMatchLabelKeys(Collection<String> items) {
        if (this.matchLabelKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.matchLabelKeys.remove(item);
        }
        return (A)this;
    }

    public List<String> getMatchLabelKeys() {
        return this.matchLabelKeys;
    }

    public String getMatchLabelKey(int index) {
        return this.matchLabelKeys.get(index);
    }

    public String getFirstMatchLabelKey() {
        return this.matchLabelKeys.get(0);
    }

    public String getLastMatchLabelKey() {
        return this.matchLabelKeys.get(this.matchLabelKeys.size() - 1);
    }

    public String getMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMatchLabelKey(Predicate<String> predicate) {
        for (String item : this.matchLabelKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchLabelKeys(List<String> matchLabelKeys) {
        if (matchLabelKeys != null) {
            this.matchLabelKeys = new ArrayList<String>();
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        } else {
            this.matchLabelKeys = null;
        }
        return (A)this;
    }

    public A withMatchLabelKeys(String ... matchLabelKeys) {
        if (this.matchLabelKeys != null) {
            this.matchLabelKeys.clear();
            this._visitables.remove("matchLabelKeys");
        }
        if (matchLabelKeys != null) {
            for (String item : matchLabelKeys) {
                this.addToMatchLabelKeys(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchLabelKeys() {
        return this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty();
    }

    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    public A withMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return (A)this;
    }

    public boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    public Integer getMinDomains() {
        return this.minDomains;
    }

    public A withMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
        return (A)this;
    }

    public boolean hasMinDomains() {
        return this.minDomains != null;
    }

    public String getNodeAffinityPolicy() {
        return this.nodeAffinityPolicy;
    }

    public A withNodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
        return (A)this;
    }

    public boolean hasNodeAffinityPolicy() {
        return this.nodeAffinityPolicy != null;
    }

    public String getNodeTaintsPolicy() {
        return this.nodeTaintsPolicy;
    }

    public A withNodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
        return (A)this;
    }

    public boolean hasNodeTaintsPolicy() {
        return this.nodeTaintsPolicy != null;
    }

    public String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    public boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public A withWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return (A)this;
    }

    public boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TopologySpreadConstraintFluent that = (V1TopologySpreadConstraintFluent)o;
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.matchLabelKeys, that.matchLabelKeys)) {
            return false;
        }
        if (!Objects.equals(this.maxSkew, that.maxSkew)) {
            return false;
        }
        if (!Objects.equals(this.minDomains, that.minDomains)) {
            return false;
        }
        if (!Objects.equals(this.nodeAffinityPolicy, that.nodeAffinityPolicy)) {
            return false;
        }
        if (!Objects.equals(this.nodeTaintsPolicy, that.nodeTaintsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.topologyKey, that.topologyKey)) {
            return false;
        }
        return Objects.equals(this.whenUnsatisfiable, that.whenUnsatisfiable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labelSelector, this.matchLabelKeys, this.maxSkew, this.minDomains, this.nodeAffinityPolicy, this.nodeTaintsPolicy, this.topologyKey, this.whenUnsatisfiable, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.matchLabelKeys != null && !this.matchLabelKeys.isEmpty()) {
            sb.append("matchLabelKeys:");
            sb.append(this.matchLabelKeys + ",");
        }
        if (this.maxSkew != null) {
            sb.append("maxSkew:");
            sb.append(this.maxSkew + ",");
        }
        if (this.minDomains != null) {
            sb.append("minDomains:");
            sb.append(this.minDomains + ",");
        }
        if (this.nodeAffinityPolicy != null) {
            sb.append("nodeAffinityPolicy:");
            sb.append(this.nodeAffinityPolicy + ",");
        }
        if (this.nodeTaintsPolicy != null) {
            sb.append("nodeTaintsPolicy:");
            sb.append(this.nodeTaintsPolicy + ",");
        }
        if (this.topologyKey != null) {
            sb.append("topologyKey:");
            sb.append(this.topologyKey + ",");
        }
        if (this.whenUnsatisfiable != null) {
            sb.append("whenUnsatisfiable:");
            sb.append(this.whenUnsatisfiable);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LabelSelectorNested<N>
    extends V1LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        LabelSelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1TopologySpreadConstraintFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

