/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1IPBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1IPBlockFluent<A extends V1IPBlockFluent<A>>
extends BaseFluent<A> {
    private String cidr;
    private List<String> except;

    public V1IPBlockFluent() {
    }

    public V1IPBlockFluent(V1IPBlock instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IPBlock instance) {
        V1IPBlock v1IPBlock = instance = instance != null ? instance : new V1IPBlock();
        if (instance != null) {
            this.withCidr(instance.getCidr());
            this.withExcept(instance.getExcept());
        }
    }

    public String getCidr() {
        return this.cidr;
    }

    public A withCidr(String cidr) {
        this.cidr = cidr;
        return (A)this;
    }

    public boolean hasCidr() {
        return this.cidr != null;
    }

    public A addToExcept(int index, String item) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.add(index, item);
        return (A)this;
    }

    public A setToExcept(int index, String item) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.set(index, item);
        return (A)this;
    }

    public A addToExcept(String ... items) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        for (String item : items) {
            this.except.add(item);
        }
        return (A)this;
    }

    public A addAllToExcept(Collection<String> items) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        for (String item : items) {
            this.except.add(item);
        }
        return (A)this;
    }

    public A removeFromExcept(String ... items) {
        if (this.except == null) {
            return (A)this;
        }
        for (String item : items) {
            this.except.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromExcept(Collection<String> items) {
        if (this.except == null) {
            return (A)this;
        }
        for (String item : items) {
            this.except.remove(item);
        }
        return (A)this;
    }

    public List<String> getExcept() {
        return this.except;
    }

    public String getExcept(int index) {
        return this.except.get(index);
    }

    public String getFirstExcept() {
        return this.except.get(0);
    }

    public String getLastExcept() {
        return this.except.get(this.except.size() - 1);
    }

    public String getMatchingExcept(Predicate<String> predicate) {
        for (String item : this.except) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExcept(Predicate<String> predicate) {
        for (String item : this.except) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExcept(List<String> except) {
        if (except != null) {
            this.except = new ArrayList<String>();
            for (String item : except) {
                this.addToExcept(item);
            }
        } else {
            this.except = null;
        }
        return (A)this;
    }

    public A withExcept(String ... except) {
        if (this.except != null) {
            this.except.clear();
            this._visitables.remove("except");
        }
        if (except != null) {
            for (String item : except) {
                this.addToExcept(item);
            }
        }
        return (A)this;
    }

    public boolean hasExcept() {
        return this.except != null && !this.except.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IPBlockFluent that = (V1IPBlockFluent)o;
        if (!Objects.equals(this.cidr, that.cidr)) {
            return false;
        }
        return Objects.equals(this.except, that.except);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cidr, this.except, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidr != null) {
            sb.append("cidr:");
            sb.append(this.cidr + ",");
        }
        if (this.except != null && !this.except.isEmpty()) {
            sb.append("except:");
            sb.append(this.except);
        }
        sb.append("}");
        return sb.toString();
    }
}

