/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1alpha1VolumeAttributesClass;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V1alpha1VolumeAttributesClassFluent<A extends V1alpha1VolumeAttributesClassFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Map<String, String> parameters;

    public V1alpha1VolumeAttributesClassFluent() {
    }

    public V1alpha1VolumeAttributesClassFluent(V1alpha1VolumeAttributesClass instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha1VolumeAttributesClass instance) {
        V1alpha1VolumeAttributesClass v1alpha1VolumeAttributesClass = instance = instance != null ? instance : new V1alpha1VolumeAttributesClass();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParameters(instance.getParameters());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToParameters(String key, String value) {
        if (this.parameters == null && key != null && value != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.parameters.put(key, value);
        }
        return (A)this;
    }

    public A addToParameters(Map<String, String> map) {
        if (this.parameters == null && map != null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.parameters.putAll(map);
        }
        return (A)this;
    }

    public A removeFromParameters(String key) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (key != null && this.parameters != null) {
            this.parameters.remove(key);
        }
        return (A)this;
    }

    public A removeFromParameters(Map<String, String> map) {
        if (this.parameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.parameters == null) continue;
                this.parameters.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public <K, V> A withParameters(Map<String, String> parameters) {
        this.parameters = parameters == null ? null : new LinkedHashMap<String, String>(parameters);
        return (A)this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1VolumeAttributesClassFluent that = (V1alpha1VolumeAttributesClassFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parameters, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("parameters:");
            sb.append(this.parameters);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1VolumeAttributesClassFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

