/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha2DriverRequests;
import io.kubernetes.client.openapi.models.V1alpha2ResourceRequest;
import io.kubernetes.client.openapi.models.V1alpha2ResourceRequestBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceRequestFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2DriverRequestsFluent<A extends V1alpha2DriverRequestsFluent<A>>
extends BaseFluent<A> {
    private String driverName;
    private ArrayList<V1alpha2ResourceRequestBuilder> requests;
    private Object vendorParameters;

    public V1alpha2DriverRequestsFluent() {
    }

    public V1alpha2DriverRequestsFluent(V1alpha2DriverRequests instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2DriverRequests instance) {
        V1alpha2DriverRequests v1alpha2DriverRequests = instance = instance != null ? instance : new V1alpha2DriverRequests();
        if (instance != null) {
            this.withDriverName(instance.getDriverName());
            this.withRequests(instance.getRequests());
            this.withVendorParameters(instance.getVendorParameters());
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public A addToRequests(int index, V1alpha2ResourceRequest item) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        V1alpha2ResourceRequestBuilder builder = new V1alpha2ResourceRequestBuilder(item);
        if (index < 0 || index >= this.requests.size()) {
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        } else {
            this._visitables.get("requests").add(index, builder);
            this.requests.add(index, builder);
        }
        return (A)this;
    }

    public A setToRequests(int index, V1alpha2ResourceRequest item) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        V1alpha2ResourceRequestBuilder builder = new V1alpha2ResourceRequestBuilder(item);
        if (index < 0 || index >= this.requests.size()) {
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        } else {
            this._visitables.get("requests").set(index, builder);
            this.requests.set(index, builder);
        }
        return (A)this;
    }

    public A addToRequests(V1alpha2ResourceRequest ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        for (V1alpha2ResourceRequest item : items) {
            V1alpha2ResourceRequestBuilder builder = new V1alpha2ResourceRequestBuilder(item);
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        }
        return (A)this;
    }

    public A addAllToRequests(Collection<V1alpha2ResourceRequest> items) {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        for (V1alpha2ResourceRequest item : items) {
            V1alpha2ResourceRequestBuilder builder = new V1alpha2ResourceRequestBuilder(item);
            this._visitables.get("requests").add(builder);
            this.requests.add(builder);
        }
        return (A)this;
    }

    public A removeFromRequests(V1alpha2ResourceRequest ... items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (V1alpha2ResourceRequest item : items) {
            V1alpha2ResourceRequestBuilder builder = new V1alpha2ResourceRequestBuilder(item);
            this._visitables.get("requests").remove(builder);
            this.requests.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRequests(Collection<V1alpha2ResourceRequest> items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (V1alpha2ResourceRequest item : items) {
            V1alpha2ResourceRequestBuilder builder = new V1alpha2ResourceRequestBuilder(item);
            this._visitables.get("requests").remove(builder);
            this.requests.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRequests(Predicate<V1alpha2ResourceRequestBuilder> predicate) {
        if (this.requests == null) {
            return (A)this;
        }
        Iterator<V1alpha2ResourceRequestBuilder> each = this.requests.iterator();
        Object visitables = this._visitables.get("requests");
        while (each.hasNext()) {
            V1alpha2ResourceRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha2ResourceRequest> buildRequests() {
        return this.requests != null ? V1alpha2DriverRequestsFluent.build(this.requests) : null;
    }

    public V1alpha2ResourceRequest buildRequest(int index) {
        return this.requests.get(index).build();
    }

    public V1alpha2ResourceRequest buildFirstRequest() {
        return this.requests.get(0).build();
    }

    public V1alpha2ResourceRequest buildLastRequest() {
        return this.requests.get(this.requests.size() - 1).build();
    }

    public V1alpha2ResourceRequest buildMatchingRequest(Predicate<V1alpha2ResourceRequestBuilder> predicate) {
        for (V1alpha2ResourceRequestBuilder item : this.requests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<V1alpha2ResourceRequestBuilder> predicate) {
        for (V1alpha2ResourceRequestBuilder item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequests(List<V1alpha2ResourceRequest> requests) {
        if (this.requests != null) {
            this._visitables.get("requests").clear();
        }
        if (requests != null) {
            this.requests = new ArrayList();
            for (V1alpha2ResourceRequest item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)this;
    }

    public A withRequests(V1alpha2ResourceRequest ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove("requests");
        }
        if (requests != null) {
            for (V1alpha2ResourceRequest item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public RequestsNested<A> addNewRequest() {
        return new RequestsNested(-1, null);
    }

    public RequestsNested<A> addNewRequestLike(V1alpha2ResourceRequest item) {
        return new RequestsNested(-1, item);
    }

    public RequestsNested<A> setNewRequestLike(int index, V1alpha2ResourceRequest item) {
        return new RequestsNested(index, item);
    }

    public RequestsNested<A> editRequest(int index) {
        if (this.requests.size() <= index) {
            throw new RuntimeException("Can't edit requests. Index exceeds size.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestsNested<A> editFirstRequest() {
        if (this.requests.size() == 0) {
            throw new RuntimeException("Can't edit first requests. The list is empty.");
        }
        return this.setNewRequestLike(0, this.buildRequest(0));
    }

    public RequestsNested<A> editLastRequest() {
        int index = this.requests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last requests. The list is empty.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestsNested<A> editMatchingRequest(Predicate<V1alpha2ResourceRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requests.size(); ++i) {
            if (!predicate.test(this.requests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching requests. No match found.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public Object getVendorParameters() {
        return this.vendorParameters;
    }

    public A withVendorParameters(Object vendorParameters) {
        this.vendorParameters = vendorParameters;
        return (A)this;
    }

    public boolean hasVendorParameters() {
        return this.vendorParameters != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2DriverRequestsFluent that = (V1alpha2DriverRequestsFluent)o;
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        return Objects.equals(this.vendorParameters, that.vendorParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driverName, this.requests, this.vendorParameters, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests + ",");
        }
        if (this.vendorParameters != null) {
            sb.append("vendorParameters:");
            sb.append(this.vendorParameters);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RequestsNested<N>
    extends V1alpha2ResourceRequestFluent<RequestsNested<N>>
    implements Nested<N> {
        V1alpha2ResourceRequestBuilder builder;
        int index;

        RequestsNested(int index, V1alpha2ResourceRequest item) {
            this.index = index;
            this.builder = new V1alpha2ResourceRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2DriverRequestsFluent.this.setToRequests(this.index, this.builder.build());
        }

        public N endRequest() {
            return this.and();
        }
    }
}

