/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1alpha2DriverRequests;
import io.kubernetes.client.openapi.models.V1alpha2DriverRequestsBuilder;
import io.kubernetes.client.openapi.models.V1alpha2DriverRequestsFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParameters;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParametersReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParametersReferenceBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParametersReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1alpha2ResourceClaimParametersFluent<A extends V1alpha2ResourceClaimParametersFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<V1alpha2DriverRequestsBuilder> driverRequests;
    private V1alpha2ResourceClaimParametersReferenceBuilder generatedFrom;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Boolean shareable;

    public V1alpha2ResourceClaimParametersFluent() {
    }

    public V1alpha2ResourceClaimParametersFluent(V1alpha2ResourceClaimParameters instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2ResourceClaimParameters instance) {
        V1alpha2ResourceClaimParameters v1alpha2ResourceClaimParameters = instance = instance != null ? instance : new V1alpha2ResourceClaimParameters();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverRequests(instance.getDriverRequests());
            this.withGeneratedFrom(instance.getGeneratedFrom());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withShareable(instance.getShareable());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToDriverRequests(int index, V1alpha2DriverRequests item) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        V1alpha2DriverRequestsBuilder builder = new V1alpha2DriverRequestsBuilder(item);
        if (index < 0 || index >= this.driverRequests.size()) {
            this._visitables.get("driverRequests").add(builder);
            this.driverRequests.add(builder);
        } else {
            this._visitables.get("driverRequests").add(index, builder);
            this.driverRequests.add(index, builder);
        }
        return (A)this;
    }

    public A setToDriverRequests(int index, V1alpha2DriverRequests item) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        V1alpha2DriverRequestsBuilder builder = new V1alpha2DriverRequestsBuilder(item);
        if (index < 0 || index >= this.driverRequests.size()) {
            this._visitables.get("driverRequests").add(builder);
            this.driverRequests.add(builder);
        } else {
            this._visitables.get("driverRequests").set(index, builder);
            this.driverRequests.set(index, builder);
        }
        return (A)this;
    }

    public A addToDriverRequests(V1alpha2DriverRequests ... items) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        for (V1alpha2DriverRequests item : items) {
            V1alpha2DriverRequestsBuilder builder = new V1alpha2DriverRequestsBuilder(item);
            this._visitables.get("driverRequests").add(builder);
            this.driverRequests.add(builder);
        }
        return (A)this;
    }

    public A addAllToDriverRequests(Collection<V1alpha2DriverRequests> items) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        for (V1alpha2DriverRequests item : items) {
            V1alpha2DriverRequestsBuilder builder = new V1alpha2DriverRequestsBuilder(item);
            this._visitables.get("driverRequests").add(builder);
            this.driverRequests.add(builder);
        }
        return (A)this;
    }

    public A removeFromDriverRequests(V1alpha2DriverRequests ... items) {
        if (this.driverRequests == null) {
            return (A)this;
        }
        for (V1alpha2DriverRequests item : items) {
            V1alpha2DriverRequestsBuilder builder = new V1alpha2DriverRequestsBuilder(item);
            this._visitables.get("driverRequests").remove(builder);
            this.driverRequests.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDriverRequests(Collection<V1alpha2DriverRequests> items) {
        if (this.driverRequests == null) {
            return (A)this;
        }
        for (V1alpha2DriverRequests item : items) {
            V1alpha2DriverRequestsBuilder builder = new V1alpha2DriverRequestsBuilder(item);
            this._visitables.get("driverRequests").remove(builder);
            this.driverRequests.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDriverRequests(Predicate<V1alpha2DriverRequestsBuilder> predicate) {
        if (this.driverRequests == null) {
            return (A)this;
        }
        Iterator<V1alpha2DriverRequestsBuilder> each = this.driverRequests.iterator();
        Object visitables = this._visitables.get("driverRequests");
        while (each.hasNext()) {
            V1alpha2DriverRequestsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha2DriverRequests> buildDriverRequests() {
        return this.driverRequests != null ? V1alpha2ResourceClaimParametersFluent.build(this.driverRequests) : null;
    }

    public V1alpha2DriverRequests buildDriverRequest(int index) {
        return this.driverRequests.get(index).build();
    }

    public V1alpha2DriverRequests buildFirstDriverRequest() {
        return this.driverRequests.get(0).build();
    }

    public V1alpha2DriverRequests buildLastDriverRequest() {
        return this.driverRequests.get(this.driverRequests.size() - 1).build();
    }

    public V1alpha2DriverRequests buildMatchingDriverRequest(Predicate<V1alpha2DriverRequestsBuilder> predicate) {
        for (V1alpha2DriverRequestsBuilder item : this.driverRequests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDriverRequest(Predicate<V1alpha2DriverRequestsBuilder> predicate) {
        for (V1alpha2DriverRequestsBuilder item : this.driverRequests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDriverRequests(List<V1alpha2DriverRequests> driverRequests) {
        if (this.driverRequests != null) {
            this._visitables.get("driverRequests").clear();
        }
        if (driverRequests != null) {
            this.driverRequests = new ArrayList();
            for (V1alpha2DriverRequests item : driverRequests) {
                this.addToDriverRequests(item);
            }
        } else {
            this.driverRequests = null;
        }
        return (A)this;
    }

    public A withDriverRequests(V1alpha2DriverRequests ... driverRequests) {
        if (this.driverRequests != null) {
            this.driverRequests.clear();
            this._visitables.remove("driverRequests");
        }
        if (driverRequests != null) {
            for (V1alpha2DriverRequests item : driverRequests) {
                this.addToDriverRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasDriverRequests() {
        return this.driverRequests != null && !this.driverRequests.isEmpty();
    }

    public DriverRequestsNested<A> addNewDriverRequest() {
        return new DriverRequestsNested(-1, null);
    }

    public DriverRequestsNested<A> addNewDriverRequestLike(V1alpha2DriverRequests item) {
        return new DriverRequestsNested(-1, item);
    }

    public DriverRequestsNested<A> setNewDriverRequestLike(int index, V1alpha2DriverRequests item) {
        return new DriverRequestsNested(index, item);
    }

    public DriverRequestsNested<A> editDriverRequest(int index) {
        if (this.driverRequests.size() <= index) {
            throw new RuntimeException("Can't edit driverRequests. Index exceeds size.");
        }
        return this.setNewDriverRequestLike(index, this.buildDriverRequest(index));
    }

    public DriverRequestsNested<A> editFirstDriverRequest() {
        if (this.driverRequests.size() == 0) {
            throw new RuntimeException("Can't edit first driverRequests. The list is empty.");
        }
        return this.setNewDriverRequestLike(0, this.buildDriverRequest(0));
    }

    public DriverRequestsNested<A> editLastDriverRequest() {
        int index = this.driverRequests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last driverRequests. The list is empty.");
        }
        return this.setNewDriverRequestLike(index, this.buildDriverRequest(index));
    }

    public DriverRequestsNested<A> editMatchingDriverRequest(Predicate<V1alpha2DriverRequestsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.driverRequests.size(); ++i) {
            if (!predicate.test(this.driverRequests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching driverRequests. No match found.");
        }
        return this.setNewDriverRequestLike(index, this.buildDriverRequest(index));
    }

    public V1alpha2ResourceClaimParametersReference buildGeneratedFrom() {
        return this.generatedFrom != null ? this.generatedFrom.build() : null;
    }

    public A withGeneratedFrom(V1alpha2ResourceClaimParametersReference generatedFrom) {
        this._visitables.remove("generatedFrom");
        if (generatedFrom != null) {
            this.generatedFrom = new V1alpha2ResourceClaimParametersReferenceBuilder(generatedFrom);
            this._visitables.get("generatedFrom").add(this.generatedFrom);
        } else {
            this.generatedFrom = null;
            this._visitables.get("generatedFrom").remove(this.generatedFrom);
        }
        return (A)this;
    }

    public boolean hasGeneratedFrom() {
        return this.generatedFrom != null;
    }

    public GeneratedFromNested<A> withNewGeneratedFrom() {
        return new GeneratedFromNested(null);
    }

    public GeneratedFromNested<A> withNewGeneratedFromLike(V1alpha2ResourceClaimParametersReference item) {
        return new GeneratedFromNested(item);
    }

    public GeneratedFromNested<A> editGeneratedFrom() {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(null));
    }

    public GeneratedFromNested<A> editOrNewGeneratedFrom() {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(new V1alpha2ResourceClaimParametersReferenceBuilder().build()));
    }

    public GeneratedFromNested<A> editOrNewGeneratedFromLike(V1alpha2ResourceClaimParametersReference item) {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Boolean getShareable() {
        return this.shareable;
    }

    public A withShareable(Boolean shareable) {
        this.shareable = shareable;
        return (A)this;
    }

    public boolean hasShareable() {
        return this.shareable != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClaimParametersFluent that = (V1alpha2ResourceClaimParametersFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverRequests, that.driverRequests)) {
            return false;
        }
        if (!Objects.equals(this.generatedFrom, that.generatedFrom)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.shareable, that.shareable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverRequests, this.generatedFrom, this.kind, this.metadata, this.shareable, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverRequests != null && !this.driverRequests.isEmpty()) {
            sb.append("driverRequests:");
            sb.append(this.driverRequests + ",");
        }
        if (this.generatedFrom != null) {
            sb.append("generatedFrom:");
            sb.append(this.generatedFrom + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.shareable != null) {
            sb.append("shareable:");
            sb.append(this.shareable);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withShareable() {
        return this.withShareable(true);
    }

    public class DriverRequestsNested<N>
    extends V1alpha2DriverRequestsFluent<DriverRequestsNested<N>>
    implements Nested<N> {
        V1alpha2DriverRequestsBuilder builder;
        int index;

        DriverRequestsNested(int index, V1alpha2DriverRequests item) {
            this.index = index;
            this.builder = new V1alpha2DriverRequestsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimParametersFluent.this.setToDriverRequests(this.index, this.builder.build());
        }

        public N endDriverRequest() {
            return this.and();
        }
    }

    public class GeneratedFromNested<N>
    extends V1alpha2ResourceClaimParametersReferenceFluent<GeneratedFromNested<N>>
    implements Nested<N> {
        V1alpha2ResourceClaimParametersReferenceBuilder builder;

        GeneratedFromNested(V1alpha2ResourceClaimParametersReference item) {
            this.builder = new V1alpha2ResourceClaimParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimParametersFluent.this.withGeneratedFrom(this.builder.build());
        }

        public N endGeneratedFrom() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimParametersFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

