/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParameters;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReferenceBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassParametersReferenceFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceFilter;
import io.kubernetes.client.openapi.models.V1alpha2ResourceFilterBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceFilterFluent;
import io.kubernetes.client.openapi.models.V1alpha2VendorParameters;
import io.kubernetes.client.openapi.models.V1alpha2VendorParametersBuilder;
import io.kubernetes.client.openapi.models.V1alpha2VendorParametersFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1alpha2ResourceClassParametersFluent<A extends V1alpha2ResourceClassParametersFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<V1alpha2ResourceFilterBuilder> filters;
    private V1alpha2ResourceClassParametersReferenceBuilder generatedFrom;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<V1alpha2VendorParametersBuilder> vendorParameters;

    public V1alpha2ResourceClassParametersFluent() {
    }

    public V1alpha2ResourceClassParametersFluent(V1alpha2ResourceClassParameters instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2ResourceClassParameters instance) {
        V1alpha2ResourceClassParameters v1alpha2ResourceClassParameters = instance = instance != null ? instance : new V1alpha2ResourceClassParameters();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withFilters(instance.getFilters());
            this.withGeneratedFrom(instance.getGeneratedFrom());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withVendorParameters(instance.getVendorParameters());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToFilters(int index, V1alpha2ResourceFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        V1alpha2ResourceFilterBuilder builder = new V1alpha2ResourceFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    public A setToFilters(int index, V1alpha2ResourceFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        V1alpha2ResourceFilterBuilder builder = new V1alpha2ResourceFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    public A addToFilters(V1alpha2ResourceFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (V1alpha2ResourceFilter item : items) {
            V1alpha2ResourceFilterBuilder builder = new V1alpha2ResourceFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A addAllToFilters(Collection<V1alpha2ResourceFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (V1alpha2ResourceFilter item : items) {
            V1alpha2ResourceFilterBuilder builder = new V1alpha2ResourceFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A removeFromFilters(V1alpha2ResourceFilter ... items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (V1alpha2ResourceFilter item : items) {
            V1alpha2ResourceFilterBuilder builder = new V1alpha2ResourceFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFilters(Collection<V1alpha2ResourceFilter> items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (V1alpha2ResourceFilter item : items) {
            V1alpha2ResourceFilterBuilder builder = new V1alpha2ResourceFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFilters(Predicate<V1alpha2ResourceFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<V1alpha2ResourceFilterBuilder> each = this.filters.iterator();
        Object visitables = this._visitables.get("filters");
        while (each.hasNext()) {
            V1alpha2ResourceFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha2ResourceFilter> buildFilters() {
        return this.filters != null ? V1alpha2ResourceClassParametersFluent.build(this.filters) : null;
    }

    public V1alpha2ResourceFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public V1alpha2ResourceFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public V1alpha2ResourceFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public V1alpha2ResourceFilter buildMatchingFilter(Predicate<V1alpha2ResourceFilterBuilder> predicate) {
        for (V1alpha2ResourceFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<V1alpha2ResourceFilterBuilder> predicate) {
        for (V1alpha2ResourceFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<V1alpha2ResourceFilter> filters) {
        if (this.filters != null) {
            this._visitables.get("filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (V1alpha2ResourceFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    public A withFilters(V1alpha2ResourceFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove("filters");
        }
        if (filters != null) {
            for (V1alpha2ResourceFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(V1alpha2ResourceFilter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, V1alpha2ResourceFilter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<V1alpha2ResourceFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public V1alpha2ResourceClassParametersReference buildGeneratedFrom() {
        return this.generatedFrom != null ? this.generatedFrom.build() : null;
    }

    public A withGeneratedFrom(V1alpha2ResourceClassParametersReference generatedFrom) {
        this._visitables.remove("generatedFrom");
        if (generatedFrom != null) {
            this.generatedFrom = new V1alpha2ResourceClassParametersReferenceBuilder(generatedFrom);
            this._visitables.get("generatedFrom").add(this.generatedFrom);
        } else {
            this.generatedFrom = null;
            this._visitables.get("generatedFrom").remove(this.generatedFrom);
        }
        return (A)this;
    }

    public boolean hasGeneratedFrom() {
        return this.generatedFrom != null;
    }

    public GeneratedFromNested<A> withNewGeneratedFrom() {
        return new GeneratedFromNested(null);
    }

    public GeneratedFromNested<A> withNewGeneratedFromLike(V1alpha2ResourceClassParametersReference item) {
        return new GeneratedFromNested(item);
    }

    public GeneratedFromNested<A> editGeneratedFrom() {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(null));
    }

    public GeneratedFromNested<A> editOrNewGeneratedFrom() {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(new V1alpha2ResourceClassParametersReferenceBuilder().build()));
    }

    public GeneratedFromNested<A> editOrNewGeneratedFromLike(V1alpha2ResourceClassParametersReference item) {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToVendorParameters(int index, V1alpha2VendorParameters item) {
        if (this.vendorParameters == null) {
            this.vendorParameters = new ArrayList();
        }
        V1alpha2VendorParametersBuilder builder = new V1alpha2VendorParametersBuilder(item);
        if (index < 0 || index >= this.vendorParameters.size()) {
            this._visitables.get("vendorParameters").add(builder);
            this.vendorParameters.add(builder);
        } else {
            this._visitables.get("vendorParameters").add(index, builder);
            this.vendorParameters.add(index, builder);
        }
        return (A)this;
    }

    public A setToVendorParameters(int index, V1alpha2VendorParameters item) {
        if (this.vendorParameters == null) {
            this.vendorParameters = new ArrayList();
        }
        V1alpha2VendorParametersBuilder builder = new V1alpha2VendorParametersBuilder(item);
        if (index < 0 || index >= this.vendorParameters.size()) {
            this._visitables.get("vendorParameters").add(builder);
            this.vendorParameters.add(builder);
        } else {
            this._visitables.get("vendorParameters").set(index, builder);
            this.vendorParameters.set(index, builder);
        }
        return (A)this;
    }

    public A addToVendorParameters(V1alpha2VendorParameters ... items) {
        if (this.vendorParameters == null) {
            this.vendorParameters = new ArrayList();
        }
        for (V1alpha2VendorParameters item : items) {
            V1alpha2VendorParametersBuilder builder = new V1alpha2VendorParametersBuilder(item);
            this._visitables.get("vendorParameters").add(builder);
            this.vendorParameters.add(builder);
        }
        return (A)this;
    }

    public A addAllToVendorParameters(Collection<V1alpha2VendorParameters> items) {
        if (this.vendorParameters == null) {
            this.vendorParameters = new ArrayList();
        }
        for (V1alpha2VendorParameters item : items) {
            V1alpha2VendorParametersBuilder builder = new V1alpha2VendorParametersBuilder(item);
            this._visitables.get("vendorParameters").add(builder);
            this.vendorParameters.add(builder);
        }
        return (A)this;
    }

    public A removeFromVendorParameters(V1alpha2VendorParameters ... items) {
        if (this.vendorParameters == null) {
            return (A)this;
        }
        for (V1alpha2VendorParameters item : items) {
            V1alpha2VendorParametersBuilder builder = new V1alpha2VendorParametersBuilder(item);
            this._visitables.get("vendorParameters").remove(builder);
            this.vendorParameters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVendorParameters(Collection<V1alpha2VendorParameters> items) {
        if (this.vendorParameters == null) {
            return (A)this;
        }
        for (V1alpha2VendorParameters item : items) {
            V1alpha2VendorParametersBuilder builder = new V1alpha2VendorParametersBuilder(item);
            this._visitables.get("vendorParameters").remove(builder);
            this.vendorParameters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVendorParameters(Predicate<V1alpha2VendorParametersBuilder> predicate) {
        if (this.vendorParameters == null) {
            return (A)this;
        }
        Iterator<V1alpha2VendorParametersBuilder> each = this.vendorParameters.iterator();
        Object visitables = this._visitables.get("vendorParameters");
        while (each.hasNext()) {
            V1alpha2VendorParametersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1alpha2VendorParameters> buildVendorParameters() {
        return this.vendorParameters != null ? V1alpha2ResourceClassParametersFluent.build(this.vendorParameters) : null;
    }

    public V1alpha2VendorParameters buildVendorParameter(int index) {
        return this.vendorParameters.get(index).build();
    }

    public V1alpha2VendorParameters buildFirstVendorParameter() {
        return this.vendorParameters.get(0).build();
    }

    public V1alpha2VendorParameters buildLastVendorParameter() {
        return this.vendorParameters.get(this.vendorParameters.size() - 1).build();
    }

    public V1alpha2VendorParameters buildMatchingVendorParameter(Predicate<V1alpha2VendorParametersBuilder> predicate) {
        for (V1alpha2VendorParametersBuilder item : this.vendorParameters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVendorParameter(Predicate<V1alpha2VendorParametersBuilder> predicate) {
        for (V1alpha2VendorParametersBuilder item : this.vendorParameters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVendorParameters(List<V1alpha2VendorParameters> vendorParameters) {
        if (this.vendorParameters != null) {
            this._visitables.get("vendorParameters").clear();
        }
        if (vendorParameters != null) {
            this.vendorParameters = new ArrayList();
            for (V1alpha2VendorParameters item : vendorParameters) {
                this.addToVendorParameters(item);
            }
        } else {
            this.vendorParameters = null;
        }
        return (A)this;
    }

    public A withVendorParameters(V1alpha2VendorParameters ... vendorParameters) {
        if (this.vendorParameters != null) {
            this.vendorParameters.clear();
            this._visitables.remove("vendorParameters");
        }
        if (vendorParameters != null) {
            for (V1alpha2VendorParameters item : vendorParameters) {
                this.addToVendorParameters(item);
            }
        }
        return (A)this;
    }

    public boolean hasVendorParameters() {
        return this.vendorParameters != null && !this.vendorParameters.isEmpty();
    }

    public VendorParametersNested<A> addNewVendorParameter() {
        return new VendorParametersNested(-1, null);
    }

    public VendorParametersNested<A> addNewVendorParameterLike(V1alpha2VendorParameters item) {
        return new VendorParametersNested(-1, item);
    }

    public VendorParametersNested<A> setNewVendorParameterLike(int index, V1alpha2VendorParameters item) {
        return new VendorParametersNested(index, item);
    }

    public VendorParametersNested<A> editVendorParameter(int index) {
        if (this.vendorParameters.size() <= index) {
            throw new RuntimeException("Can't edit vendorParameters. Index exceeds size.");
        }
        return this.setNewVendorParameterLike(index, this.buildVendorParameter(index));
    }

    public VendorParametersNested<A> editFirstVendorParameter() {
        if (this.vendorParameters.size() == 0) {
            throw new RuntimeException("Can't edit first vendorParameters. The list is empty.");
        }
        return this.setNewVendorParameterLike(0, this.buildVendorParameter(0));
    }

    public VendorParametersNested<A> editLastVendorParameter() {
        int index = this.vendorParameters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last vendorParameters. The list is empty.");
        }
        return this.setNewVendorParameterLike(index, this.buildVendorParameter(index));
    }

    public VendorParametersNested<A> editMatchingVendorParameter(Predicate<V1alpha2VendorParametersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.vendorParameters.size(); ++i) {
            if (!predicate.test(this.vendorParameters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching vendorParameters. No match found.");
        }
        return this.setNewVendorParameterLike(index, this.buildVendorParameter(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClassParametersFluent that = (V1alpha2ResourceClassParametersFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.generatedFrom, that.generatedFrom)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.vendorParameters, that.vendorParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.filters, this.generatedFrom, this.kind, this.metadata, this.vendorParameters, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.generatedFrom != null) {
            sb.append("generatedFrom:");
            sb.append(this.generatedFrom + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.vendorParameters != null && !this.vendorParameters.isEmpty()) {
            sb.append("vendorParameters:");
            sb.append(this.vendorParameters);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FiltersNested<N>
    extends V1alpha2ResourceFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        V1alpha2ResourceFilterBuilder builder;
        int index;

        FiltersNested(int index, V1alpha2ResourceFilter item) {
            this.index = index;
            this.builder = new V1alpha2ResourceFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassParametersFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }

    public class GeneratedFromNested<N>
    extends V1alpha2ResourceClassParametersReferenceFluent<GeneratedFromNested<N>>
    implements Nested<N> {
        V1alpha2ResourceClassParametersReferenceBuilder builder;

        GeneratedFromNested(V1alpha2ResourceClassParametersReference item) {
            this.builder = new V1alpha2ResourceClassParametersReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassParametersFluent.this.withGeneratedFrom(this.builder.build());
        }

        public N endGeneratedFrom() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassParametersFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class VendorParametersNested<N>
    extends V1alpha2VendorParametersFluent<VendorParametersNested<N>>
    implements Nested<N> {
        V1alpha2VendorParametersBuilder builder;
        int index;

        VendorParametersNested(int index, V1alpha2VendorParameters item) {
            this.index = index;
            this.builder = new V1alpha2VendorParametersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClassParametersFluent.this.setToVendorParameters(this.index, this.builder.build());
        }

        public N endVendorParameter() {
            return this.and();
        }
    }
}

