/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.RbacV1Subject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1RoleRef;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1RoleBinding
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_ROLE_REF = "roleRef";
    @SerializedName(value="roleRef")
    private V1RoleRef roleRef;
    public static final String SERIALIZED_NAME_SUBJECTS = "subjects";
    @SerializedName(value="subjects")
    private List<RbacV1Subject> subjects;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1RoleBinding apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1RoleBinding kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1RoleBinding metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1RoleBinding roleRef(V1RoleRef roleRef) {
        this.roleRef = roleRef;
        return this;
    }

    @Nonnull
    public V1RoleRef getRoleRef() {
        return this.roleRef;
    }

    public void setRoleRef(V1RoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public V1RoleBinding subjects(List<RbacV1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public V1RoleBinding addSubjectsItem(RbacV1Subject subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<RbacV1Subject>();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    @Nullable
    public List<RbacV1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<RbacV1Subject> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RoleBinding v1RoleBinding = (V1RoleBinding)o;
        return Objects.equals(this.apiVersion, v1RoleBinding.apiVersion) && Objects.equals(this.kind, v1RoleBinding.kind) && Objects.equals(this.metadata, v1RoleBinding.metadata) && Objects.equals(this.roleRef, v1RoleBinding.roleRef) && Objects.equals(this.subjects, v1RoleBinding.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.roleRef, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1RoleBinding {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    roleRef: ").append(this.toIndentedString(this.roleRef)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysubjects;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1RoleBinding is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1RoleBinding` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
        V1RoleRef.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ROLE_REF));
        if (jsonObj.get(SERIALIZED_NAME_SUBJECTS) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECTS).isJsonNull() && (jsonArraysubjects = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBJECTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBJECTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subjects` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECTS).toString()));
            }
            for (int i = 0; i < jsonArraysubjects.size(); ++i) {
                RbacV1Subject.validateJsonObject(jsonArraysubjects.get(i).getAsJsonObject());
            }
        }
    }

    public static V1RoleBinding fromJson(String jsonString) throws IOException {
        return (V1RoleBinding)JSON.getGson().fromJson(jsonString, V1RoleBinding.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_ROLE_REF);
        openapiFields.add(SERIALIZED_NAME_SUBJECTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ROLE_REF);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1RoleBinding.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1RoleBinding.class));
            return new TypeAdapter<V1RoleBinding>(){

                public void write(JsonWriter out, V1RoleBinding value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1RoleBinding read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1RoleBinding.validateJsonObject(jsonObj);
                    return (V1RoleBinding)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

