/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesRequest;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesRequestBuilder;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesRequestFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceRequest;
import java.util.Objects;
import java.util.Optional;

public class V1alpha2ResourceRequestFluent<A extends V1alpha2ResourceRequestFluent<A>>
extends BaseFluent<A> {
    private V1alpha2NamedResourcesRequestBuilder namedResources;
    private Object vendorParameters;

    public V1alpha2ResourceRequestFluent() {
    }

    public V1alpha2ResourceRequestFluent(V1alpha2ResourceRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2ResourceRequest instance) {
        V1alpha2ResourceRequest v1alpha2ResourceRequest = instance = instance != null ? instance : new V1alpha2ResourceRequest();
        if (instance != null) {
            this.withNamedResources(instance.getNamedResources());
            this.withVendorParameters(instance.getVendorParameters());
        }
    }

    public V1alpha2NamedResourcesRequest buildNamedResources() {
        return this.namedResources != null ? this.namedResources.build() : null;
    }

    public A withNamedResources(V1alpha2NamedResourcesRequest namedResources) {
        this._visitables.remove("namedResources");
        if (namedResources != null) {
            this.namedResources = new V1alpha2NamedResourcesRequestBuilder(namedResources);
            this._visitables.get("namedResources").add(this.namedResources);
        } else {
            this.namedResources = null;
            this._visitables.get("namedResources").remove(this.namedResources);
        }
        return (A)this;
    }

    public boolean hasNamedResources() {
        return this.namedResources != null;
    }

    public NamedResourcesNested<A> withNewNamedResources() {
        return new NamedResourcesNested(null);
    }

    public NamedResourcesNested<A> withNewNamedResourcesLike(V1alpha2NamedResourcesRequest item) {
        return new NamedResourcesNested(item);
    }

    public NamedResourcesNested<A> editNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(null));
    }

    public NamedResourcesNested<A> editOrNewNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(new V1alpha2NamedResourcesRequestBuilder().build()));
    }

    public NamedResourcesNested<A> editOrNewNamedResourcesLike(V1alpha2NamedResourcesRequest item) {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(item));
    }

    public Object getVendorParameters() {
        return this.vendorParameters;
    }

    public A withVendorParameters(Object vendorParameters) {
        this.vendorParameters = vendorParameters;
        return (A)this;
    }

    public boolean hasVendorParameters() {
        return this.vendorParameters != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceRequestFluent that = (V1alpha2ResourceRequestFluent)o;
        if (!Objects.equals(this.namedResources, that.namedResources)) {
            return false;
        }
        return Objects.equals(this.vendorParameters, that.vendorParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namedResources, this.vendorParameters, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namedResources != null) {
            sb.append("namedResources:");
            sb.append(this.namedResources + ",");
        }
        if (this.vendorParameters != null) {
            sb.append("vendorParameters:");
            sb.append(this.vendorParameters);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamedResourcesNested<N>
    extends V1alpha2NamedResourcesRequestFluent<NamedResourcesNested<N>>
    implements Nested<N> {
        V1alpha2NamedResourcesRequestBuilder builder;

        NamedResourcesNested(V1alpha2NamedResourcesRequest item) {
            this.builder = new V1alpha2NamedResourcesRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceRequestFluent.this.withNamedResources(this.builder.build());
        }

        public N endNamedResources() {
            return this.and();
        }
    }
}

