/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplate;
import io.cert.manager.models.V1alpha2IssuerSpecAcmeHttp01IngressPodTemplate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The ingress based HTTP01 challenge solver will solve challenges by creating or modifying Ingress resources in order to route requests for '/.well-known/acme-challenge/XYZ' to 'challenge solver' pods that are provisioned by cert-manager for each Challenge to be completed.")
public class V1alpha2IssuerSpecAcmeHttp01Ingress {
    public static final String SERIALIZED_NAME_PROPERTY_CLASS = "class";
    @SerializedName(value="class")
    private String propertyClass;
    public static final String SERIALIZED_NAME_INGRESS_TEMPLATE = "ingressTemplate";
    @SerializedName(value="ingressTemplate")
    private V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplate ingressTemplate;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_POD_TEMPLATE = "podTemplate";
    @SerializedName(value="podTemplate")
    private V1alpha2IssuerSpecAcmeHttp01IngressPodTemplate podTemplate;
    public static final String SERIALIZED_NAME_SERVICE_TYPE = "serviceType";
    @SerializedName(value="serviceType")
    private String serviceType;

    public V1alpha2IssuerSpecAcmeHttp01Ingress propertyClass(String propertyClass) {
        this.propertyClass = propertyClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ingress class to use when creating Ingress resources to solve ACME challenges that use this challenge solver. Only one of 'class' or 'name' may be specified.")
    public String getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(String propertyClass) {
        this.propertyClass = propertyClass;
    }

    public V1alpha2IssuerSpecAcmeHttp01Ingress ingressTemplate(V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplate ingressTemplate) {
        this.ingressTemplate = ingressTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplate getIngressTemplate() {
        return this.ingressTemplate;
    }

    public void setIngressTemplate(V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplate ingressTemplate) {
        this.ingressTemplate = ingressTemplate;
    }

    public V1alpha2IssuerSpecAcmeHttp01Ingress name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the ingress resource that should have ACME challenge solving routes inserted into it in order to solve HTTP01 challenges. This is typically used in conjunction with ingress controllers like ingress-gce, which maintains a 1:1 mapping between external IPs and ingress resources.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha2IssuerSpecAcmeHttp01Ingress podTemplate(V1alpha2IssuerSpecAcmeHttp01IngressPodTemplate podTemplate) {
        this.podTemplate = podTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2IssuerSpecAcmeHttp01IngressPodTemplate getPodTemplate() {
        return this.podTemplate;
    }

    public void setPodTemplate(V1alpha2IssuerSpecAcmeHttp01IngressPodTemplate podTemplate) {
        this.podTemplate = podTemplate;
    }

    public V1alpha2IssuerSpecAcmeHttp01Ingress serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional service type for Kubernetes solver service")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecAcmeHttp01Ingress v1alpha2IssuerSpecAcmeHttp01Ingress = (V1alpha2IssuerSpecAcmeHttp01Ingress)o;
        return Objects.equals(this.propertyClass, v1alpha2IssuerSpecAcmeHttp01Ingress.propertyClass) && Objects.equals(this.ingressTemplate, v1alpha2IssuerSpecAcmeHttp01Ingress.ingressTemplate) && Objects.equals(this.name, v1alpha2IssuerSpecAcmeHttp01Ingress.name) && Objects.equals(this.podTemplate, v1alpha2IssuerSpecAcmeHttp01Ingress.podTemplate) && Objects.equals(this.serviceType, v1alpha2IssuerSpecAcmeHttp01Ingress.serviceType);
    }

    public int hashCode() {
        return Objects.hash(this.propertyClass, this.ingressTemplate, this.name, this.podTemplate, this.serviceType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecAcmeHttp01Ingress {\n");
        sb.append("    propertyClass: ").append(this.toIndentedString(this.propertyClass)).append("\n");
        sb.append("    ingressTemplate: ").append(this.toIndentedString(this.ingressTemplate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    podTemplate: ").append(this.toIndentedString(this.podTemplate)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

