/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ObjectMeta overrides for the ingress used to solve HTTP01 challenges. Only the 'labels' and 'annotations' fields may be set. If labels or annotations overlap with in-built values, the values here will override the in-built values.")
public class V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata {
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private Map<String, String> annotations = null;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = null;

    public V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations that should be added to the created ACME HTTP01 solver ingress.")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Labels that should be added to the created ACME HTTP01 solver ingress.")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata v1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata = (V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata)o;
        return Objects.equals(this.annotations, v1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata.annotations) && Objects.equals(this.labels, v1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata.labels);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecAcmeHttp01IngressIngressTemplateMetadata {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

