/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CA configures this issuer to sign certificates using a signing CA keypair stored in a Secret resource. This is used to build internal PKIs that are managed by cert-manager.")
public class V1alpha2IssuerSpecCa {
    public static final String SERIALIZED_NAME_CRL_DISTRIBUTION_POINTS = "crlDistributionPoints";
    @SerializedName(value="crlDistributionPoints")
    private List<String> crlDistributionPoints = null;
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    private String secretName;

    public V1alpha2IssuerSpecCa crlDistributionPoints(List<String> crlDistributionPoints) {
        this.crlDistributionPoints = crlDistributionPoints;
        return this;
    }

    public V1alpha2IssuerSpecCa addCrlDistributionPointsItem(String crlDistributionPointsItem) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(crlDistributionPointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CRL distribution points is an X.509 v3 certificate extension which identifies the location of the CRL from which the revocation of this certificate can be checked. If not set, certificates will be issued without distribution points set.")
    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    public void setCrlDistributionPoints(List<String> crlDistributionPoints) {
        this.crlDistributionPoints = crlDistributionPoints;
    }

    public V1alpha2IssuerSpecCa secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @ApiModelProperty(required=true, value="SecretName is the name of the secret used to sign Certificates issued by this Issuer.")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecCa v1alpha2IssuerSpecCa = (V1alpha2IssuerSpecCa)o;
        return Objects.equals(this.crlDistributionPoints, v1alpha2IssuerSpecCa.crlDistributionPoints) && Objects.equals(this.secretName, v1alpha2IssuerSpecCa.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints, this.secretName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecCa {\n");
        sb.append("    crlDistributionPoints: ").append(this.toIndentedString(this.crlDistributionPoints)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

