/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.PortForward;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.KubectlExec;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class KubectlPortForward
extends Kubectl.ResourceAndContainerBuilder<V1Pod, KubectlPortForward>
implements Kubectl.Executable<Boolean> {
    List<Integer> localPorts;
    List<Integer> targetPorts;
    boolean running;
    Consumer<Throwable> onUnhandledError = Throwable::printStackTrace;

    KubectlPortForward() {
        super(V1Pod.class);
        this.localPorts = new ArrayList<Integer>();
        this.targetPorts = new ArrayList<Integer>();
    }

    public KubectlPortForward ports(int localPort, int targetPort) {
        this.localPorts.add(localPort);
        this.targetPorts.add(targetPort);
        return this;
    }

    public KubectlPortForward onUnhandledError(Consumer<Throwable> onUnhandledError) {
        this.onUnhandledError = onUnhandledError;
        return this;
    }

    @Override
    public Boolean execute() throws KubectlException {
        this.running = true;
        try {
            this.executeInternal();
            return true;
        }
        catch (ApiException | IOException | InterruptedException ex) {
            throw new KubectlException(ex);
        }
    }

    public void shutdown() {
        this.running = false;
    }

    private void executeInternal() throws ApiException, KubectlException, IOException, InterruptedException {
        PortForward pf = new PortForward(this.apiClient);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < this.localPorts.size(); ++i) {
            int targetPort = this.targetPorts.get(i);
            threads.add(this.portForward(pf, new ServerSocket(this.localPorts.get(i)), targetPort));
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    private Thread portForward(final PortForward pf, final ServerSocket server, final int targetPort) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (KubectlPortForward.this.running) {
                    try {
                        Socket sock = server.accept();
                        try {
                            PortForward.PortForwardResult result = pf.forward(KubectlPortForward.this.namespace, KubectlPortForward.this.name, Arrays.asList(targetPort));
                            if (result == null) {
                                throw new KubectlException("PortForward failed!");
                            }
                            InputStream in = result.getInputStream(targetPort);
                            OutputStream out = result.getOutboundStream(targetPort);
                            Thread t1 = KubectlExec.copyAsync(sock.getInputStream(), out, KubectlPortForward.this.onUnhandledError);
                            Thread t2 = KubectlExec.copyAsync(in, sock.getOutputStream(), KubectlPortForward.this.onUnhandledError);
                            t1.join();
                            in.close();
                            t2.join();
                        }
                        finally {
                            if (sock == null) continue;
                            sock.close();
                        }
                    }
                    catch (Exception ex) {
                        Optional.ofNullable(KubectlPortForward.this.onUnhandledError).orElse(Throwable::printStackTrace).accept(ex);
                    }
                }
            }
        });
        t.start();
        return t;
    }
}

