/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore")
public class V1ThanosRulerSpecAwsElasticBlockStore {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_PARTITION = "partition";
    @SerializedName(value="partition")
    private Integer partition;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_VOLUME_I_D = "volumeID";
    @SerializedName(value="volumeID")
    private String volumeID;

    public V1ThanosRulerSpecAwsElasticBlockStore fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore TODO: how do we prevent errors in the filesystem from compromising the machine")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1ThanosRulerSpecAwsElasticBlockStore partition(Integer partition) {
        this.partition = partition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty).")
    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public V1ThanosRulerSpecAwsElasticBlockStore readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify \"true\" to force and set the ReadOnly property in VolumeMounts to \"true\". If omitted, the default is \"false\". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1ThanosRulerSpecAwsElasticBlockStore volumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore")
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecAwsElasticBlockStore v1ThanosRulerSpecAwsElasticBlockStore = (V1ThanosRulerSpecAwsElasticBlockStore)o;
        return Objects.equals(this.fsType, v1ThanosRulerSpecAwsElasticBlockStore.fsType) && Objects.equals(this.partition, v1ThanosRulerSpecAwsElasticBlockStore.partition) && Objects.equals(this.readOnly, v1ThanosRulerSpecAwsElasticBlockStore.readOnly) && Objects.equals(this.volumeID, v1ThanosRulerSpecAwsElasticBlockStore.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.partition, this.readOnly, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecAwsElasticBlockStore {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    partition: ").append(this.toIndentedString(this.partition)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

