/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.coreos.monitoring.models.V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims")
public class V1ThanosRulerSpecStorageVolumeClaimTemplateStatus {
    public static final String SERIALIZED_NAME_ACCESS_MODES = "accessModes";
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, String> capacity = null;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions> conditions = null;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private String phase;

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus capacity(Map<String, String> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus putCapacityItem(String key, String capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, String>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the actual resources of the underlying volume.")
    public Map<String, String> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, String> capacity) {
        this.capacity = capacity;
    }

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus conditions(List<V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus addConditionsItem(V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.")
    public List<V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1ThanosRulerSpecStorageVolumeClaimTemplateStatusConditions> conditions) {
        this.conditions = conditions;
    }

    public V1ThanosRulerSpecStorageVolumeClaimTemplateStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phase represents the current phase of PersistentVolumeClaim.")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecStorageVolumeClaimTemplateStatus v1ThanosRulerSpecStorageVolumeClaimTemplateStatus = (V1ThanosRulerSpecStorageVolumeClaimTemplateStatus)o;
        return Objects.equals(this.accessModes, v1ThanosRulerSpecStorageVolumeClaimTemplateStatus.accessModes) && Objects.equals(this.capacity, v1ThanosRulerSpecStorageVolumeClaimTemplateStatus.capacity) && Objects.equals(this.conditions, v1ThanosRulerSpecStorageVolumeClaimTemplateStatus.conditions) && Objects.equals(this.phase, v1ThanosRulerSpecStorageVolumeClaimTemplateStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.capacity, this.conditions, this.phase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecStorageVolumeClaimTemplateStatus {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

