/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterslave.MasterSlaveConnectionProvider;
import io.lettuce.core.masterslave.ReadOnlyCommands;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

class MasterSlaveChannelWriter
implements RedisChannelWriter {
    private MasterSlaveConnectionProvider<?, ?> masterSlaveConnectionProvider;
    private final ClientResources clientResources;
    private boolean closed = false;
    private boolean inTransaction;

    MasterSlaveChannelWriter(MasterSlaveConnectionProvider<?, ?> masterSlaveConnectionProvider, ClientResources clientResources) {
        this.masterSlaveConnectionProvider = masterSlaveConnectionProvider;
        this.clientResources = clientResources;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        if (MasterSlaveChannelWriter.isStartTransaction(command.getType())) {
            this.inTransaction = true;
        }
        MasterSlaveConnectionProvider.Intent intent = this.inTransaction ? MasterSlaveConnectionProvider.Intent.WRITE : MasterSlaveChannelWriter.getIntent(command.getType());
        CompletableFuture<StatefulRedisConnection<?, ?>> future = this.masterSlaveConnectionProvider.getConnectionAsync(intent);
        if (this.isEndTransaction(command.getType())) {
            this.inTransaction = false;
        }
        if (MasterSlaveChannelWriter.isSuccessfullyCompleted(future)) {
            MasterSlaveChannelWriter.writeCommand(command, future.join(), null);
        } else {
            future.whenComplete((c, t) -> MasterSlaveChannelWriter.writeCommand(command, c, t));
        }
        return command;
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            command.completeExceptionally(throwable);
            return;
        }
        try {
            connection.dispatch(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        for (RedisCommand<K, V, ?> command : commands) {
            if (!MasterSlaveChannelWriter.isStartTransaction(command.getType())) continue;
            this.inTransaction = true;
            break;
        }
        MasterSlaveConnectionProvider.Intent intent = this.inTransaction ? MasterSlaveConnectionProvider.Intent.WRITE : MasterSlaveChannelWriter.getIntent(commands);
        CompletableFuture<StatefulRedisConnection<?, ?>> future = this.masterSlaveConnectionProvider.getConnectionAsync(intent);
        for (RedisCommand<K, V, ?> command : commands) {
            if (!this.isEndTransaction(command.getType())) continue;
            this.inTransaction = false;
            break;
        }
        if (MasterSlaveChannelWriter.isSuccessfullyCompleted(future)) {
            MasterSlaveChannelWriter.writeCommands(commands, future.join(), null);
        } else {
            future.whenComplete((c, t) -> MasterSlaveChannelWriter.writeCommands(commands, c, t));
        }
        return commands;
    }

    private static <K, V> void writeCommands(Collection<? extends RedisCommand<K, V, ?>> commands, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            commands.forEach(c -> c.completeExceptionally(throwable));
            return;
        }
        try {
            connection.dispatch(commands);
        }
        catch (Exception e) {
            commands.forEach(c -> c.completeExceptionally(e));
        }
    }

    static MasterSlaveConnectionProvider.Intent getIntent(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        boolean w = false;
        boolean r = false;
        MasterSlaveConnectionProvider.Intent singleIntent = MasterSlaveConnectionProvider.Intent.WRITE;
        for (RedisCommand<?, ?, ?> command : commands) {
            singleIntent = MasterSlaveChannelWriter.getIntent(command.getType());
            if (singleIntent == MasterSlaveConnectionProvider.Intent.READ) {
                r = true;
            }
            if (singleIntent == MasterSlaveConnectionProvider.Intent.WRITE) {
                w = true;
            }
            if (!r || !w) continue;
            return MasterSlaveConnectionProvider.Intent.WRITE;
        }
        return singleIntent;
    }

    private static MasterSlaveConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        return ReadOnlyCommands.isReadOnlyCommand(type) ? MasterSlaveConnectionProvider.Intent.READ : MasterSlaveConnectionProvider.Intent.WRITE;
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = true;
        CompletableFuture<Void> future = null;
        if (this.masterSlaveConnectionProvider != null) {
            future = this.masterSlaveConnectionProvider.closeAsync();
            this.masterSlaveConnectionProvider = null;
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    MasterSlaveConnectionProvider<?, ?> getMasterSlaveConnectionProvider() {
        return this.masterSlaveConnectionProvider;
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connection) {
    }

    @Override
    public ClientResources getClientResources() {
        return this.clientResources;
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.masterSlaveConnectionProvider.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.masterSlaveConnectionProvider.flushCommands();
    }

    @Override
    public void reset() {
        this.masterSlaveConnectionProvider.reset();
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.masterSlaveConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.masterSlaveConnectionProvider.getReadFrom();
    }

    private static boolean isSuccessfullyCompleted(CompletableFuture<?> connectFuture) {
        return connectFuture.isDone() && !connectFuture.isCompletedExceptionally();
    }

    private static boolean isStartTransaction(ProtocolKeyword command) {
        return command.name().equals("MULTI");
    }

    private boolean isEndTransaction(ProtocolKeyword command) {
        return command.name().equals("EXEC") || command.name().equals("DISCARD");
    }
}

