/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.KeyValue;
import io.lettuce.core.LettuceStrings;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;

public class KeyValueScoredValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, ScoredValue<V>>> {
    private K key;
    private V value;

    public KeyValueScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.output = KeyValue.just(this.key, ScoredValue.just(score, this.value));
        this.key = null;
        this.value = null;
    }
}

