/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.api.push.PushMessage;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ReplayOutput;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.DecodeBufferPolicy;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.PubSubMessage;
import io.lettuce.core.pubsub.PubSubOutput;
import io.lettuce.core.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class PubSubCommandHandler<K, V>
extends CommandHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PubSubCommandHandler.class);
    private final PubSubEndpoint<K, V> endpoint;
    private final RedisCodec<K, V> codec;
    private final Deque<ReplayOutput<K, V>> queue = new ArrayDeque<ReplayOutput<K, V>>();
    private final DecodeBufferPolicy decodeBufferPolicy;
    private ResponseHeaderReplayOutput<K, V> replay;
    private PubSubOutput<K, V> output;

    public PubSubCommandHandler(ClientOptions clientOptions, ClientResources clientResources, RedisCodec<K, V> codec, PubSubEndpoint<K, V> endpoint) {
        super(clientOptions, clientResources, endpoint);
        this.endpoint = endpoint;
        this.codec = codec;
        this.decodeBufferPolicy = clientOptions.getDecodeBufferPolicy();
        this.output = new PubSubOutput<K, V>(codec);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.replay = null;
        this.queue.clear();
        super.channelInactive(ctx);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        ReplayOutput<K, V> replay;
        if (this.output.type() != null && !this.output.isCompleted()) {
            if (!super.decode(buffer, this.output)) {
                this.decodeBufferPolicy.afterPartialDecode(buffer);
                return;
            }
            RedisCommand<?, ?, ?> peek = this.getStack().peek();
            this.canComplete(peek);
            this.doNotifyMessage(this.output);
            this.output = new PubSubOutput<K, V>(this.codec);
        }
        if (!this.getStack().isEmpty() || this.isPushDecode(buffer)) {
            super.decode(ctx, buffer);
        }
        while ((replay = this.queue.poll()) != null) {
            replay.replay(this.output);
            this.doNotifyMessage(this.output);
            this.output = new PubSubOutput<K, V>(this.codec);
        }
        while (super.getStack().isEmpty() && buffer.isReadable()) {
            if (!super.decode(buffer, this.output)) {
                this.decodeBufferPolicy.afterPartialDecode(buffer);
                return;
            }
            this.doNotifyMessage(this.output);
            this.output = new PubSubOutput<K, V>(this.codec);
        }
        this.decodeBufferPolicy.afterDecoding(buffer);
    }

    @Override
    protected boolean canDecode(ByteBuf buffer) {
        return super.canDecode(buffer) && this.output.type() == null;
    }

    @Override
    protected boolean canComplete(RedisCommand<?, ?, ?> command) {
        if (PubSubCommandHandler.isResp2PubSubMessage(this.replay)) {
            this.queue.add(this.replay);
            this.replay = null;
            return false;
        }
        return super.canComplete(command);
    }

    @Override
    protected void complete(RedisCommand<?, ?, ?> command) {
        if (this.replay != null && command.getOutput() != null) {
            try {
                this.replay.replay(command.getOutput());
            }
            catch (Exception e) {
                command.completeExceptionally(e);
            }
            this.replay = null;
        }
        super.complete(command);
    }

    private static boolean isResp2PubSubMessage(ResponseHeaderReplayOutput<?, ?> replay) {
        if (replay == null) {
            return false;
        }
        String firstElement = replay.firstElement;
        if (replay.multiCount != null && firstElement != null) {
            if (replay.multiCount == 3 && firstElement.equalsIgnoreCase(PubSubOutput.Type.message.name())) {
                return true;
            }
            if (replay.multiCount == 4 && firstElement.equalsIgnoreCase(PubSubOutput.Type.pmessage.name())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CommandOutput<?, ?, ?> getCommandOutput(RedisCommand<?, ?, ?> command) {
        if (this.getStack().isEmpty() || command.getOutput() == null) {
            return super.getCommandOutput(command);
        }
        if (this.replay == null) {
            this.replay = new ResponseHeaderReplayOutput();
        }
        return this.replay;
    }

    @Override
    protected void notifyPushListeners(PushMessage notification) {
        if (PubSubOutput.Type.isPubSubType(notification.getType())) {
            PubSubOutput.Type type = PubSubOutput.Type.valueOf(notification.getType());
            RedisCommand<?, ?, ?> command = this.getStack().peek();
            if (command != null && this.shouldCompleteCommand(type, command)) {
                this.completeCommand(notification, command);
            }
            this.doNotifyMessage(this.toPubSubMessage(notification));
        }
        super.notifyPushListeners(notification);
    }

    private boolean shouldCompleteCommand(PubSubOutput.Type type, RedisCommand<?, ?, ?> command) {
        String commandType = command.getType().name();
        switch (type) {
            case subscribe: {
                return commandType.equalsIgnoreCase("SUBSCRIBE");
            }
            case ssubscribe: {
                return commandType.equalsIgnoreCase("SSUBSCRIBE");
            }
            case psubscribe: {
                return commandType.equalsIgnoreCase("PSUBSCRIBE");
            }
            case unsubscribe: {
                return commandType.equalsIgnoreCase("UNSUBSCRIBE");
            }
            case sunsubscribe: {
                return commandType.equalsIgnoreCase("SUNSUBSCRIBE");
            }
            case punsubscribe: {
                return commandType.equalsIgnoreCase("PUNSUBSCRIBE");
            }
        }
        return false;
    }

    private void completeCommand(PushMessage notification, RedisCommand<?, ?, ?> command) {
        CommandOutput<?, ?, ?> output = command.getOutput();
        for (Object value : notification.getContent()) {
            if (value instanceof Long) {
                output.set((Long)value);
                continue;
            }
            output.set((ByteBuffer)value);
        }
        this.getStack().poll().complete();
    }

    private PubSubMessage<K, V> toPubSubMessage(PushMessage notification) {
        PubSubOutput<K, V> output = new PubSubOutput<K, V>(this.codec);
        for (Object argument : notification.getContent()) {
            if (argument instanceof Long) {
                output.set((Long)argument);
                continue;
            }
            output.set((ByteBuffer)argument);
        }
        return output;
    }

    @Override
    protected void afterDecode(ChannelHandlerContext ctx, RedisCommand<?, ?, ?> command) {
        super.afterDecode(ctx, command);
        if (command.getOutput() instanceof PubSubOutput) {
            this.doNotifyMessage((PubSubOutput)command.getOutput());
        }
    }

    private void doNotifyMessage(PubSubMessage<K, V> message) {
        try {
            this.endpoint.notifyMessage(message);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in PubSubEndpoint.notifyMessage", (Throwable)e);
        }
    }

    static class ResponseHeaderReplayOutput<K, V>
    extends ReplayOutput<K, V> {
        Integer multiCount;
        String firstElement;

        ResponseHeaderReplayOutput() {
        }

        @Override
        public void set(ByteBuffer bytes) {
            if (this.firstElement == null && bytes != null && bytes.remaining() > 0) {
                bytes.mark();
                this.firstElement = StringCodec.ASCII.decodeKey(bytes);
                bytes.reset();
            }
            super.set(bytes);
        }

        @Override
        public void multi(int count) {
            if (this.multiCount == null) {
                this.multiCount = count;
            }
            super.multi(count);
        }
    }
}

