/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDockerMojo
extends AbstractMojo {
    public static final String DEFAULT_GRAAL_DOCKER_VERSION = "java11";
    public static final String LATEST_TAG = "latest";
    public static final String DEFAULT_BASE_IMAGE_GRAALVM_RUN = "frolvlad/alpine-glibc:alpine-3.12";
    public static final String MOSTLY_STATIC_NATIVE_IMAGE_GRAALVM_FLAG = "-H:+StaticExecutableWithDynamicLibC";
    protected final MavenProject mavenProject;
    protected final JibConfigurationService jibConfigurationService;
    protected final ApplicationConfigurationService applicationConfigurationService;
    protected final DockerService dockerService;
    @Parameter(property="micronaut.native-image.args")
    protected List<String> nativeImageBuildArgs;
    @Parameter(property="mn.appArgs")
    protected List<String> appArguments;
    @Parameter(defaultValue="${exec.mainClass}", required=true)
    protected String mainClass;
    @Parameter(defaultValue="false", property="micronaut.native-image.static")
    protected Boolean staticNativeImage;
    @Parameter(property="micronaut.runtime", defaultValue="NONE")
    protected String micronautRuntime;
    @Parameter(property="micronaut.native-image.base-image-run", defaultValue="frolvlad/alpine-glibc:alpine-3.12")
    protected String baseImageRun;

    protected AbstractDockerMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService) {
        this.mavenProject = mavenProject;
        this.jibConfigurationService = jibConfigurationService;
        this.applicationConfigurationService = applicationConfigurationService;
        this.dockerService = dockerService;
    }

    protected ArtifactVersion javaVersion() {
        return new DefaultArtifactVersion(Optional.ofNullable(this.mavenProject.getProperties().getProperty("maven.compiler.target")).orElse(System.getProperty("java.version")));
    }

    protected String graalVmVersion() {
        return this.mavenProject.getProperties().getProperty("graal.version");
    }

    protected String graalVmJvmVersion() {
        String graalVmJvmVersion = "java8";
        if (this.javaVersion().getMajorVersion() >= 11) {
            graalVmJvmVersion = DEFAULT_GRAAL_DOCKER_VERSION;
        }
        return graalVmJvmVersion;
    }

    protected String getFrom() {
        return this.jibConfigurationService.getFromImage().orElse("ghcr.io/graalvm/graalvm-ce:java11-" + this.graalVmVersion());
    }

    protected Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        Optional<String> toImageOptional = this.jibConfigurationService.getToImage();
        String imageName = this.mavenProject.getArtifactId();
        if (toImageOptional.isPresent()) {
            String toImage = toImageOptional.get();
            if (toImage.contains(":")) {
                tags.add(toImage);
                imageName = toImageOptional.get().split(":")[0];
            } else {
                tags.add(toImage + ":" + LATEST_TAG);
                imageName = toImage;
            }
        } else {
            tags.add(imageName + ":" + LATEST_TAG);
        }
        for (String tag : this.jibConfigurationService.getTags()) {
            if (LATEST_TAG.equals(tag) && tags.stream().anyMatch(t -> t.contains(LATEST_TAG))) continue;
            tags.add(String.format("%s:%s", imageName, tag));
        }
        return tags;
    }

    protected String getPort() {
        String port = this.applicationConfigurationService.getServerPort();
        return "-1".equals(port) ? "8080" : port;
    }

    protected void copyDependencies() throws IOException {
        List<String> imageClasspathScopes = Arrays.asList("compile", "runtime");
        this.mavenProject.setArtifactFilter(artifact -> imageClasspathScopes.contains(artifact.getScope()));
        File target = new File(this.mavenProject.getBuild().getDirectory(), "dependency");
        if (!target.exists()) {
            target.mkdirs();
        }
        for (Artifact dependency : this.mavenProject.getArtifacts()) {
            Files.copy(dependency.getFile().toPath(), target.toPath().resolve(dependency.getFile().getName()), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected String getCmd() {
        return "CMD [" + this.appArguments.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + "]";
    }

    protected String getGraalVmBuildArgs() {
        if (this.nativeImageBuildArgs != null && !this.nativeImageBuildArgs.isEmpty()) {
            return String.join((CharSequence)" ", this.nativeImageBuildArgs);
        }
        return "";
    }
}

