/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.services;

import com.google.cloud.tools.jib.api.Credential;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Singleton
public class JibConfigurationService {
    private static final String IMAGE = "image";
    private static final String CONTAINER = "container";
    private static final String WORKING_DIRECTORY = "workingDirectory";
    private Xpp3Dom configuration;
    private Xpp3Dom to;
    private Xpp3Dom from;

    @Inject
    public JibConfigurationService(MavenProject mavenProject) {
        Plugin plugin = mavenProject.getPlugin("com.google.cloud.tools:jib-maven-plugin");
        if (plugin != null && plugin.getConfiguration() != null) {
            this.configuration = (Xpp3Dom)plugin.getConfiguration();
            this.to = this.configuration.getChild("to");
            this.from = this.configuration.getChild("from");
        }
    }

    public Optional<String> getToImage() {
        String propertyValue = System.getProperties().getProperty("jib.to.image");
        Optional<String> result = propertyValue != null ? Optional.of(propertyValue) : (this.to != null ? Optional.ofNullable(this.to.getChild(IMAGE).getValue()) : Optional.empty());
        return result;
    }

    public Optional<String> getFromImage() {
        String propertyValue = System.getProperties().getProperty("jib.from.image");
        Optional<String> result = propertyValue != null ? Optional.of(propertyValue) : (this.from != null ? Optional.ofNullable(this.from.getChild(IMAGE).getValue()) : Optional.empty());
        return result;
    }

    public Set<String> getTags() {
        Set<String> result = null;
        String propertyValue = System.getProperties().getProperty("jib.to.tags");
        if (propertyValue != null) {
            result = new HashSet<String>(JibConfigurationService.parseCommaSeparatedList(propertyValue));
        } else {
            Xpp3Dom tags;
            if (this.to != null && (tags = this.to.getChild("tags")) != null && tags.getChildCount() > 0) {
                result = Arrays.stream(tags.getChildren()).map(Xpp3Dom::getValue).collect(Collectors.toSet());
            }
            if (result == null) {
                result = Collections.emptySet();
            }
        }
        return result;
    }

    public Optional<Credential> getCredentials() {
        Xpp3Dom auth;
        Optional<Credential> result = Optional.empty();
        String usernameProp = System.getProperties().getProperty("jib.to.auth.username");
        String passwordProp = System.getProperties().getProperty("jib.to.auth.password");
        if (usernameProp != null && passwordProp != null) {
            result = Optional.of(Credential.from((String)usernameProp, (String)passwordProp));
        } else if (this.to != null && (auth = this.to.getChild("auth")) != null) {
            Xpp3Dom username = auth.getChild("username");
            Xpp3Dom password = auth.getChild("password");
            if (username != null && password != null) {
                result = Optional.of(Credential.from((String)username.getValue(), (String)password.getValue()));
            }
        }
        return result;
    }

    public Optional<String> getCredHelper() {
        Xpp3Dom credHelper;
        Optional<String> result = Optional.empty();
        String propertyValue = System.getProperties().getProperty("jib.to.credHelper");
        if (propertyValue != null) {
            result = Optional.of(propertyValue);
        } else if (this.to != null && (credHelper = this.to.getChild("credHelper")) != null) {
            result = Optional.of(credHelper.getValue());
        }
        return result;
    }

    public Optional<String> getWorkingDirectory() {
        Xpp3Dom container;
        if (this.configuration != null && (container = this.configuration.getChild(CONTAINER)) != null && container.getChild(WORKING_DIRECTORY) != null) {
            return Optional.ofNullable(container.getChild(WORKING_DIRECTORY).getValue());
        }
        return Optional.empty();
    }

    public List<String> getArgs() {
        Xpp3Dom container;
        ArrayList<String> result = new ArrayList<String>();
        if (this.configuration != null && (container = this.configuration.getChild(CONTAINER)) != null) {
            Xpp3Dom args = container.getChild("args");
            if (args.getChildCount() > 0) {
                for (Xpp3Dom arg : args.getChildren()) {
                    result.add(arg.getValue());
                }
            } else {
                result.add(args.getValue());
            }
        }
        return result;
    }

    private static Set<String> parseCommaSeparatedList(String list) {
        String[] parts = list.split(",");
        HashSet<String> items = new HashSet<String>(parts.length);
        for (String part : parts) {
            items.add(part.trim());
        }
        return items;
    }
}

