/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.maven;

import io.openapiprocessor.maven.Nested;
import io.openapiprocessor.maven.Options;
import io.openapiprocessor.maven.ProcessorRunner;
import io.openapiprocessor.maven.UpToDateCheck;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ProcessMojo
extends AbstractMojo {
    public static final String API_PATH = "apiPath";
    public static final String TARGET_DIR = "targetDir";
    @Parameter(required=true)
    private String id;
    @Parameter(required=true)
    private File apiPath;
    @Parameter(required=false)
    private Options options;
    @Parameter(required=false, defaultValue="true")
    private boolean addSourceRoot;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        String processor = String.format("openapi-processor-%s", this.id);
        try {
            this.getLog().info((CharSequence)String.format("%10s - %s", "processor", processor));
            Map<String, Object> properties = this.createProperties();
            File source = this.apiPath.getParentFile();
            String relativeSource = this.stripBaseDir(source.getAbsolutePath());
            this.getLog().info((CharSequence)String.format("%10s - ${project.basedir}%s%s", API_PATH, File.pathSeparator, relativeSource));
            String targetDir = (String)properties.computeIfAbsent(TARGET_DIR, k -> this.project.getBuild().getDirectory() + File.pathSeparator + "generated-sources" + File.pathSeparator + this.id);
            if (this.addSourceRoot) {
                this.project.addCompileSourceRoot(targetDir);
            }
            String relativeTargetDir = this.stripBaseDir(targetDir);
            this.getLog().info((CharSequence)String.format("%10s - ${project.basedir}%s%s", TARGET_DIR, File.pathSeparator, relativeTargetDir));
            File targetRoot = new File(targetDir);
            UpToDateCheck upToDateCheck = new UpToDateCheck();
            boolean upToDate = upToDateCheck.isUpToDate(source, targetRoot);
            if (!upToDate) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Changes detected - generating target files!");
                new ProcessorRunner(this.id, properties).run();
            } else {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Nothing to process - all generated target files are up to date.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Execution failed - %s", processor), e);
        }
    }

    private String stripBaseDir(String source) {
        Path base = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]);
        Path src = Paths.get(source, new String[0]);
        return base.relativize(src).toString();
    }

    private Map<String, Object> createProperties() throws MojoExecutionException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.addProperties(this.options, properties);
        this.setApiPath(properties);
        return properties;
    }

    private void addProperties(Options options, Map<String, Object> target) {
        if (options == null) {
            return;
        }
        Map<String, Object> source = options.getValues();
        if (source == null) {
            return;
        }
        target.putAll(source);
        this.addNestedProperties(options.getNested(), target);
    }

    private void addNestedProperties(Nested nested, Map<String, Object> parent) {
        if (nested == null) {
            return;
        }
        Map<String, Object> source = nested.getValues();
        if (source == null) {
            return;
        }
        HashMap<String, Object> target = new HashMap<String, Object>(source);
        parent.put(nested.getName(), target);
        this.addNestedProperties(nested.getNested(), target);
    }

    private void setApiPath(Map<String, Object> properties) throws MojoExecutionException {
        if (!properties.containsKey(API_PATH)) {
            if (this.apiPath == null) {
                throw new MojoExecutionException((Object)this, "'common <apiPath>' or '" + this.id + " <apiPath>' not set!", "'common <apiPath>' or '" + this.id + " <apiPath>' not set!");
            }
            properties.put(API_PATH, this.apiPath);
        } else {
            this.apiPath = new File((String)properties.get(API_PATH));
        }
    }
}

