/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public final class EventDataAssert
extends AbstractAssert<EventDataAssert, EventData> {
    EventDataAssert(@Nullable EventData actual) {
        super((Object)actual, EventDataAssert.class);
    }

    public EventDataAssert hasName(String name) {
        this.isNotNull();
        if (!((EventData)this.actual).getName().equals(name)) {
            this.failWithActualExpectedAndMessage(((EventData)this.actual).getName(), name, "Expected event to have name <%s> but was <%s>", new Object[]{name, ((EventData)this.actual).getName()});
        }
        return this;
    }

    public EventDataAssert hasTimestamp(long timestampNanos) {
        this.isNotNull();
        if (((EventData)this.actual).getEpochNanos() != timestampNanos) {
            this.failWithActualExpectedAndMessage(((EventData)this.actual).getEpochNanos(), timestampNanos, "Expected event [%s] to have timestamp <%s> nanos but was <%s>", new Object[]{((EventData)this.actual).getName(), timestampNanos, ((EventData)this.actual).getEpochNanos()});
        }
        return this;
    }

    public EventDataAssert hasTimestamp(long timestamp, TimeUnit unit) {
        return this.hasTimestamp(unit.toNanos(timestamp));
    }

    public EventDataAssert hasTimestamp(Instant timestamp) {
        return this.hasTimestamp(TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano());
    }

    public EventDataAssert hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!((EventData)this.actual).getAttributes().equals(attributes)) {
            this.failWithActualExpectedAndMessage(((EventData)this.actual).getAttributes(), attributes, "Expected event [%s] to have attributes <%s> but was <%s>", new Object[]{((EventData)this.actual).getName(), attributes, ((EventData)this.actual).getAttributes()});
        }
        return this;
    }

    public EventDataAssert hasAttributesSatisfying(Consumer<Attributes> attributes) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((EventData)this.actual).getAttributes()).as("attributes", new Object[0])).satisfies(new Consumer[]{attributes});
        return this;
    }
}

