/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.HashMap;
import java.util.Map;

public class LocalSpanContext {
    private static final ThreadLocal<Map<String, LocalSpanContext>> instance = new ThreadLocal();
    private final String name;
    private final Span span;
    private final Scope scope;
    private int counter = 1;

    private LocalSpanContext(String name, Span span, Scope scope) {
        this.name = name;
        this.span = span;
        this.scope = scope;
    }

    public static LocalSpanContext get(String name) {
        Map<String, LocalSpanContext> map = instance.get();
        return map == null ? null : map.get(name);
    }

    public static void set(String name, Span span, Scope scope) {
        if (instance.get() == null) {
            instance.set(new HashMap());
        }
        instance.get().put(name, new LocalSpanContext(name, span, scope));
    }

    public Span getSpan() {
        return this.span;
    }

    public void increment() {
        ++this.counter;
    }

    public int decrementAndGet() {
        return --this.counter;
    }

    public void closeAndFinish() {
        this.closeScope();
        if (this.span != null) {
            this.span.finish();
        }
    }

    public void closeScope() {
        Map<String, LocalSpanContext> map = instance.get();
        if (map != null) {
            map.remove(this.name);
            if (map.isEmpty()) {
                instance.remove();
            }
        }
        if (this.scope != null) {
            this.scope.close();
        }
    }
}

