/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.mock.MockSpan;
import io.opentracing.mock.MockTracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TestUtil {
    private static final int MIN_PORT = 15000;
    private static final int MAX_PORT = 32000;
    private static final AtomicInteger port = new AtomicInteger(15000);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int nextFreePort() {
        int p;
        while ((p = port.getAndIncrement()) <= 32000) {
            try (ServerSocket socket = new ServerSocket(p);){
                int n = p;
                return n;
            }
            catch (Exception exception) {
            }
        }
        throw new RuntimeException("Unable to find a free port");
    }

    public static CountDownLatch initExpectedSpanLatch(int expectedSpans) {
        if (!(TestUtil.getGlobalTracer() instanceof MockTracer)) {
            return null;
        }
        final CountDownLatch latch = new CountDownLatch(expectedSpans);
        TestUtil.setGlobalTracer(new MockTracer(){

            @Override
            protected void onSpanFinished(MockSpan mockSpan) {
                super.onSpanFinished(mockSpan);
                latch.countDown();
            }
        });
        return latch;
    }

    private static MockTracer getTracer() {
        Tracer tracer = TestUtil.getGlobalTracer();
        if (tracer instanceof NoopTracer) {
            throw new AssertionError((Object)"No tracer is registered");
        }
        return tracer instanceof MockTracer ? (MockTracer)tracer : null;
    }

    public static void printSpans() {
        MockTracer tracer = TestUtil.getTracer();
        if (tracer != null) {
            TestUtil.printSpans(tracer);
        }
    }

    private static void printSpans(MockTracer tracer) {
        List<MockSpan> spans = tracer.finishedSpans();
        System.out.println("Spans: " + spans);
    }

    public static void checkSpan(ComponentSpanCount ... componentSpanCounts) {
        try {
            TestUtil.checkSpan(false, null, componentSpanCounts);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void checkSpan(boolean sameTrace, ComponentSpanCount ... componentSpanCounts) {
        try {
            TestUtil.checkSpan(sameTrace, null, componentSpanCounts);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void checkSpan(CountDownLatch latch, ComponentSpanCount ... componentSpanCounts) throws InterruptedException {
        TestUtil.checkSpan(false, latch, componentSpanCounts);
    }

    public static void checkSpan(boolean sameTrace, CountDownLatch latch, ComponentSpanCount ... componentSpanCounts) throws InterruptedException {
        MockTracer tracer = TestUtil.getTracer();
        if (tracer == null) {
            return;
        }
        if (latch != null) {
            latch.await(1L, TimeUnit.MINUTES);
        }
        TestUtil.printSpans(tracer);
        List<MockSpan> spans = tracer.finishedSpans();
        HashMap<String, Integer> spanCountMap = new HashMap<String, Integer>();
        HashMap<String, Long> traceIdMap = new HashMap<String, Long>();
        HashSet<Long> traceIds = new HashSet<Long>();
        for (MockSpan span : spans) {
            TestUtil.printSpan(span);
            for (ComponentSpanCount componentSpanCount : componentSpanCounts) {
                String spanComponent = (String)span.tags().get(Tags.COMPONENT.getKey());
                if (spanComponent == null || !spanComponent.matches(componentSpanCount.componentName)) continue;
                if (!spanCountMap.containsKey(componentSpanCount.componentName)) {
                    spanCountMap.put(componentSpanCount.componentName, 1);
                } else {
                    spanCountMap.put(componentSpanCount.componentName, (Integer)spanCountMap.get(componentSpanCount.componentName) + 1);
                }
                if (componentSpanCount.sameTrace && traceIdMap.containsKey(componentSpanCount.componentName) && !((Long)traceIdMap.get(componentSpanCount.componentName)).equals(span.context().traceId())) {
                    throw new AssertionError((Object)("Not the same trace of " + componentSpanCount.componentName));
                }
                traceIds.add(span.context().traceId());
                traceIdMap.put(componentSpanCount.componentName, span.context().traceId());
            }
        }
        if (sameTrace && traceIds.size() > 1) {
            throw new AssertionError((Object)"Not the same trace");
        }
        for (ComponentSpanCount componentSpanCount : componentSpanCounts) {
            if (!spanCountMap.containsKey(componentSpanCount.componentName)) {
                throw new AssertionError((Object)("\"" + componentSpanCount.componentName + "\" span not found"));
            }
            if ((Integer)spanCountMap.get(componentSpanCount.componentName) != componentSpanCount.count) {
                throw new AssertionError((Object)(spanCountMap.get(componentSpanCount.componentName) + " spans instead of " + componentSpanCount.count + " of " + componentSpanCount.componentName));
            }
        }
        tracer.reset();
    }

    private static void printSpan(MockSpan span) {
        System.out.println("Span: " + span);
        System.out.println("\tComponent: " + span.tags().get(Tags.COMPONENT.getKey()));
        System.out.println("\tTags: " + span.tags());
        System.out.println("\tLogs: ");
        for (MockSpan.LogEntry logEntry : span.logEntries()) {
            System.out.println("\t" + logEntry.fields());
        }
    }

    public static void checkActiveSpan() {
        Span span = GlobalTracer.get().activeSpan();
        System.out.println("Active span: " + span);
        if (span == null) {
            throw new AssertionError((Object)"No active span");
        }
    }

    public static Callable<Integer> reportedSpansSize(final MockTracer tracer) {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return tracer.finishedSpans().size();
            }
        };
    }

    public static void resetTracer() {
        MockTracer tracer = TestUtil.getTracer();
        if (tracer != null) {
            tracer.reset();
        }
    }

    public static void retry(Runnable runnable, int maxRetries) throws Exception {
        for (int i = 1; i <= maxRetries; ++i) {
            try {
                runnable.run();
                return;
            }
            catch (Throwable t) {
                if (i != maxRetries) continue;
                throw t;
            }
        }
    }

    public static <T> T retry(Callable<T> callable, int maxRetries) throws Exception {
        for (int i = 1; i <= maxRetries; ++i) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                if (i != maxRetries) continue;
                throw t;
            }
        }
        return null;
    }

    public static Tracer getGlobalTracer() {
        try {
            Field field = GlobalTracer.class.getDeclaredField("tracer");
            field.setAccessible(true);
            Tracer tracer = (Tracer)field.get(null);
            field.setAccessible(false);
            return tracer;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setGlobalTracer(Tracer tracer) {
        try {
            Field tracerField = GlobalTracer.class.getDeclaredField("tracer");
            tracerField.setAccessible(true);
            tracerField.set(null, tracer);
            tracerField.setAccessible(false);
            Field isRegisteredField = GlobalTracer.class.getDeclaredField("isRegistered");
            isRegisteredField.setAccessible(true);
            isRegisteredField.set(null, true);
            isRegisteredField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private TestUtil() {
    }

    public static class ComponentSpanCount {
        private final String componentName;
        private final int count;
        private final boolean sameTrace;

        public ComponentSpanCount(String componentName, int count) {
            this(componentName, count, false);
        }

        public ComponentSpanCount(String componentName, int count, boolean sameTrace) {
            this.componentName = componentName;
            this.count = count;
            this.sameTrace = sameTrace;
        }
    }
}

